# -*- coding: utf-8 -*-
from mpfs.platform.fields import UrlField, StringField, SerializerField
from mpfs.platform.serializers import BaseSerializer, ErrorWithContextSerializer


class RostelecomUnableToInitSerializer(ErrorWithContextSerializer):
    visible_fields = ErrorWithContextSerializer.visible_fields + ['registration_link']
    fields = {
        'registration_link': UrlField(source='registration_link', help_text=u'Ссылка на дорегистрацию.'),
    }


class RostelecomCheckResponseSerializer(BaseSerializer):
    visible_fields = ['uid']
    fields = {
        'uid': StringField(help_text=u'Идентификатор пользователя'),
    }


class RostelecomServiceStatusSerializer(BaseSerializer):
    visible_fields = ['status']
    fields = {
        'status': StringField(help_text=u'Статус услуги'),
    }


class RostelecomServiceDescriptionSerializer(BaseSerializer):
    visible_fields = ['key']
    fields = {
        'key': StringField(help_text=u'Название услуги'),
    }


class RostelecomServiceSerializer(BaseSerializer):
    visible_fields = ['status', 'service']
    fields = {
        'service': SerializerField(RostelecomServiceDescriptionSerializer, help_text=u'Характеристики услуги'),
        'status': StringField(source='status', help_text=u'Статус услуги'),
    }


class RostelecomServiceListSerializer(BaseSerializer):
    visible_fields = ['items']
    fields = {
        'items': SerializerField(RostelecomServiceSerializer, many=True, help_text=u'Список услуг')
    }
