# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.serializers import BaseSerializer


class SourceIdSerializer(BaseSerializer):
    fields = {
        'source_id': fields.StringField(help_text=u'Source id ресурса.')
    }


class AddSourceIdBodySerializer(BaseSerializer):
    fields = {
        'md5': fields.StringField(required=True, help_text=u'MD5-хэш.'),
        'sha256': fields.StringField(required=True, help_text=u'SHA256-хэш.'),
        'size': fields.IntegerField(required=True, help_text=u'Размер файла.'),
        'is_live_photo': fields.BooleanField(default=False, help_text=u'Идентификатор того, что хеши принадлежат live photo файлу.'),
        'items': fields.SerializerField(SourceIdSerializer, many=True, required=True, help_text=u'Список source id.'),
    }


class SourceIdExistenceCheckSerializer(BaseSerializer):
    """Результат проверки наличия source_id"""
    fields = {
        'source_id': fields.SerializerField(SourceIdSerializer, required=True, help_text=u'Source id.'),
        'found': fields.BooleanField(help_text=u'Результат проверки наличия source id.')
    }


class BulkSourceIdExistenceCheckListSerializer(BaseSerializer):
    """Результат балковой проверки наличия source_id"""
    fields = {
        'items': fields.SerializerField(SourceIdExistenceCheckSerializer, many=True, help_text=u'Список результатов проверок.'),
    }


class BulkCheckSourceIdsListBodySerializer(BaseSerializer):
    """Сериализатор тела пользовательского запроса на балковую проверку наличия source_id"""
    fields = {
        'source_ids': fields.SerializerField(SourceIdSerializer, many=True, help_text=u'Список source id.'),
    }
