# -*- coding: utf-8 -*-
"""
Disk validators.

A validator is merely a callable object or function that takes a value and simply returns nothing if the value is valid
or raises a ValidationError if not.
"""
from mpfs.common.util import parameters_checker
from mpfs.platform.exceptions import FieldValidationError


class ForbiddenPathSymbolsValidator(object):
    def __call__(self, value):
        try:
            parameters_checker.check_path_forbidden_symbols(value)
        except ValueError:
            msg = u'недопустимый символ'
            desc = u'bad symbol found'
            raise FieldValidationError(message=msg, description=desc)
