# -*- coding: utf-8 -*-
from mpfs.platform.resources import BaseResource
from mpfs.platform.v1.notes.handlers import NotesProxyHandler


class NotesResource(BaseResource):
    relations = {
        'GET': NotesProxyHandler,
        'PUT': NotesProxyHandler,
        'POST': NotesProxyHandler,
        'PATCH': NotesProxyHandler,
        'DELETE': NotesProxyHandler
    }

    _access_control_allow_headers = {'If-Match', 'X-Mtime', 'If-None-Match', 'X-Actual-Revision', 'X-Request-Id'}
    """
    Нужно на OPTIONS возвращать эти заголовки в Access-Control-Allow-Headers https://st.yandex-team.ru/CHEMODAN-57925
    """

    def get_allowed_headers(self, request, allow_headers=None):
        """Возвращает список заголовков для CORS заголовка Access-Control-Allow-Headers"""
        return super(NotesResource, self).get_allowed_headers(request, self._access_control_allow_headers)

