# -*- coding: utf-8 -*-
from mpfs.platform.resources import BaseResource, adhoc
from mpfs.platform.v1.notifier import handlers
from mpfs.platform.common import HTTP_VERBS


class NotifierServiceNamespace(BaseResource):
    relations = {method: handlers.NotifierProxyHandler for method in HTTP_VERBS}


class NotifierNamespace(BaseResource):
    """Центр нотификаций"""
    relations = {
        'notifications/(?P<service>[^/]+)/(?P<notification_entity_type>[^/]+)/(?P<notification_id>[^/]+)/mark-as-read': adhoc('PUT', handlers.MarkNotificationAsReadHandler),
        'service/(?P<notifier_path_part>.+)': NotifierServiceNamespace,
    }
