# -*- coding: utf-8 -*-
from mpfs.platform import exceptions


class PersonalityAddressesUidMustBeIntegerError(exceptions.ValidationError):
    description = 'User id must be an integer value'


class PersonalityAddressesNotFoundError(exceptions.NotFoundError):
    description = 'Address not found'


class PersonalityAddressExistsError(exceptions.NotFoundError):
    description = 'Address with such id already exists'


class PersonalityHomeRegionNotFoundError(exceptions.NotFoundError):
    description = 'Home region not found'


class PersonalityEventNotFoundError(exceptions.NotFoundError):
    description = 'Event not found'


class PersonalityYaTicketsOrderNotFoundError(exceptions.NotFoundError):
    description = 'Ya-tickets Order not found'


class PersonalityYaTicketsOrderExistsError(exceptions.BadRequestError):
    description = 'Order exists'


class PersonalityObjectNotFoundError(exceptions.NotFoundError):
    description = 'Personality object not found'


class PersonalityUserNotFoundError(exceptions.NotFoundError):
    description = 'User not found'
    message = u'Пользователь не найден.'


class PersonalityMethodNotAllowedError(exceptions.MethodNotAllowedError):
    description = 'Method not allowed for personality object'


class PersonalityObjectValidationError(exceptions.ValidationError):
    description = 'Personality object data not valid'


class PersonalityUnknownObjectTypeError(exceptions.BadRequestError):
    description = 'Unknown personality object type'


class YTObjectNotFoundError(exceptions.NotFoundError):
    description = 'YT object not found'


class PersonalityRewriteIfConditionError(exceptions.ConflictError):
    description = 'Data does not satisfy condition in rewrite_if'
