# -*- coding: utf-8 -*-
from collections import OrderedDict
from mpfs.platform.resources import NamespaceResource, BaseResource
from mpfs.platform.v1.personality.handlers import (GetFlightHandler, GetActualFlightsListHandler,
                                                   CreateActualFlightHandler, SaveActualFlightHandler,
                                                   DeleteActualFlightHandler,
                                                   GetYaTicketsOrdersListHandler, GetYaTicketsOrderHandler,
                                                   SaveYaTicketsOrderHandler,
                                                   DeleteYaTicketsOrderHandler, DeleteOldAddressDataApiHandler,
                                                   GetOldAddressDataApiHandler, ListOldAddressesDataApiHandler,
                                                   SaveOldAddressDataApiHandler,
                                                   GenericObjectHandler, GetNotificationsCountHandler,
                                                   DocsSaveObjectHandler)


class OldAddressResource(BaseResource):
    """Адрес пользователя"""
    relations = {
        'GET': GetOldAddressDataApiHandler,
        'DELETE': DeleteOldAddressDataApiHandler,
    }


class OldAddressesDataSourceCollection(BaseResource):
    """Адреса пользователя от заданного источника"""
    relations = {
        'GET': ListOldAddressesDataApiHandler,
        '(?P<data_key>[^/]+)': OldAddressResource,
    }


class OldAddressesCollection(BaseResource):
    """Адреса пользователя"""
    relations = {
        'GET': ListOldAddressesDataApiHandler,
        'PUT': SaveOldAddressDataApiHandler,
        '(?P<data_source>[^/]+)': OldAddressesDataSourceCollection,
    }


class ActualFlightListResource(BaseResource):
    relations = {
        'GET': GetActualFlightsListHandler,
        'POST': CreateActualFlightHandler
    }


class ActualFlightResource(BaseResource):
    relations = {
        'GET': GetFlightHandler,
        'PUT': SaveActualFlightHandler,
        'DELETE': DeleteActualFlightHandler,
    }


class EventsNamespace(NamespaceResource):
    """События пользователя"""
    relations = {
        'flights/actual': ActualFlightListResource,
        'flights/actual/(?P<event_id>[^/]+)': ActualFlightResource
    }


class YaTicketsOrderResource(BaseResource):
    relations = {
        'GET': GetYaTicketsOrderHandler,
        'PUT': SaveYaTicketsOrderHandler,
        'DELETE': DeleteYaTicketsOrderHandler,
    }


class YaTicketsNamespace(BaseResource):
    """Заказы пользователя в сервисе Я.Билеты"""
    relations = {
        'GET': GetYaTicketsOrdersListHandler,
        '(?P<order_id>[^/]+)': YaTicketsOrderResource
    }


class GenericObjectsNamespace(BaseResource):
    relations = {
        'GET': GenericObjectHandler,
        'PUT': GenericObjectHandler,
        'DELETE': GenericObjectHandler,
        'POST': GenericObjectHandler
    }


class NotificationsNamespace(BaseResource):
    relations = {
        'GET': GetNotificationsCountHandler,
    }


class DocsObjectResource(BaseResource):
    relations = {
        'POST': DocsSaveObjectHandler,
    }


class DocsNamespace(BaseResource):
    relations = {
        '(?P<resource_path>.+)': DocsObjectResource,
    }


class ProfileResource(BaseResource):
    """Профиль пользователя"""
    relations = OrderedDict([
        ('addresses', OldAddressesCollection),
        ('events', EventsNamespace),
        ('ya-tickets/orders', YaTicketsNamespace),
        ('notifications/unread-count', NotificationsNamespace),
        ('docs', DocsNamespace),
        ('(?P<resource_path>.+)', GenericObjectsNamespace),
    ])


class PersonalityNamespace(NamespaceResource):
    """API Персонализации"""
    relations = {
        'profile': ProfileResource,
    }
