# -*- coding: utf-8 -*-
from mpfs.platform.exceptions import (
    BadRequestError)


class PsBillingBadRequestError(BadRequestError):
    description = 'Failed to process PS Billing request.'
    message = u'Не удалось выполнить успешно запрос в PS Billing.'


class PsBillingInappReceiptIsInvalidError(BadRequestError):
    description = 'Receipt is invalid.'
    message = u'Некорректный receipt.'


class PsBillingInappUidMismatchError(BadRequestError):
    description = 'Uid mismatch.'
    message = u'Uid авторизации не соответствует uid чека.'


class PsBillingInappStoreAccountMismatchError(BadRequestError):
    description = 'Multiuser store.'
    message = u'Подписка приобретена с другого аккаунта стора.'


class PsBillingInappApplicationMismatchError(BadRequestError):
    description = 'Wrong application.'
    message = u'Подписка приобретена в другом приложении.'


class PsBillingInappYandexAccountMismatchError(BadRequestError):
    description = 'Multiuser Yandex.'
    message = u'Подписка в сторе приобретена на другой Яндекс аккаунт.'

class PsBillingPromocodeAlreadyActivated(BadRequestError):
    description = 'Promocode already activated'
    message = u'Промокод уже активирован.'
