# -*- coding: utf-8 -*-

from mpfs.platform import fields
from mpfs.platform.rate_limiters import PerUserRateLimiter
from mpfs.platform.v1.psbilling.handlers import PsBillingAPIProxyHandler
from mpfs.platform.v1.psbilling.orders.serializers import GetOrderSerializer


class GetOrderHandler(PsBillingAPIProxyHandler):
    serializer_cls = GetOrderSerializer
    service_method = 'GET'
    service_url = '/v1/orders/%(order_id)s?__uid=%(uid)s'
    resp_status_code = 200

    rate_limiter = PerUserRateLimiter('cloud_api_user_psbilling_user_services')

    kwargs = fields.QueryDict({
        'order_id': fields.StringField(required=True, help_text=u'Идентификатор заказа')
    })
