# -*- coding: utf-8 -*-

from mpfs.platform import fields
from mpfs.platform.rate_limiters import PerUserRateLimiter
from mpfs.platform.utils import quote_string
from mpfs.platform.v1.psbilling.handlers import PsBillingAPIProxyHandler
from mpfs.platform.v1.psbilling.promo.serializers import GetFuturePromosSerializer


class GetFuturePromosHandler(PsBillingAPIProxyHandler):
    serializer_cls = GetFuturePromosSerializer
    service_method = 'GET'
    service_url = '/v1/promo/future?__uid=%(uid)s'
    resp_status_code = 200

    rate_limiter = PerUserRateLimiter('cloud_api_user_psbilling_user_services')

    query = fields.QueryDict({
        'payload_type': fields.StringField(required=False,
                                           help_text=u'Тип возвращаемого пейлоада.'),
        'payload_version': fields.IntegerField(required=False,
                                               help_text=u'Версия возвращаемого пейлоада.'),
    })

    def get_url(self, context=None):
        url = super(GetFuturePromosHandler, self).get_url(context=context)

        payload_type = self.request.query.get('payload_type', None)
        if payload_type:
            url += '&payload_type=%s' % quote_string(payload_type)

        payload_version = self.request.query.get('payload_version', None)
        if payload_version is not None:
            url += '&payload_version=%s' % quote_string(payload_version)

        return url
