# -*- coding: utf-8 -*-
from mpfs.platform.rate_limiters import PerUserRateLimiter
from mpfs.platform.v1.disk.permissions import DiskPromoCodesWritePermission
from mpfs.platform.v1.psbilling.handlers import PsBillingAPIProxyHandler
from mpfs.platform.v1.psbilling.promocode.serializers import (
    ActivatePromocodeResultSerializer,
    PsBillingPromoCodeActivateBodySerializer,
)


class PSBillingPromoCodeActivateHandler(PsBillingAPIProxyHandler):
    serializer_cls = ActivatePromocodeResultSerializer
    body_serializer_cls = PsBillingPromoCodeActivateBodySerializer
    service_method = 'POST'
    service_url = '/v1/promocode/codes/%(promo_code)s/activate?__uid=%(uid)s'
    permissions = DiskPromoCodesWritePermission()
    hidden = True

    rate_limiter = PerUserRateLimiter('cloud_api_user_psbilling_user_services')

    def get_context(self, context=None):
        c = super(PSBillingPromoCodeActivateHandler, self).get_context(context)
        c['promo_code'] = self.request.body['promo_code']
        return c


