# -*- coding: utf-8 -*-

from mpfs.platform.fields import StringField
from mpfs.platform.serializers import BaseSerializer

class PsBillingPromoCodeActivateBodySerializer(BaseSerializer):
    """Сериализатор тела пользовательского запроса на активацию промокода"""
    visible_fields = ['promo_code']
    fields = {
        'promo_code': StringField(help_text=u'Промокод.', required=True),
    }

class ActivatePromocodeResultSerializer(BaseSerializer):
    fields = {
        'is_activated': StringField(help_text=u'Активирован ли.', required=True),
        'promocode_type': StringField(help_text=u'Тип промокода.', required=True)
    }
    visible_fields = fields.keys()
