# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.v1.psbilling.handlers import PsBillingAPIProxyHandler
from mpfs.platform.v1.psbilling.users.inapp.serializers import ProcessInappReceiptBodySerializer, ReceiptResponseSerializer
from mpfs.common.util import to_json


class ProcessInappReceiptHandler(PsBillingAPIProxyHandler):
    service_url = '/v1/users/inapp/receipt?__uid=%(uid)s&price_id=%(price_id)s&store_id=%(store_id)s' \
                  '&package_name=%(package_name)s&currency=%(currency)s'
    hidden = True
    body_serializer_cls = ProcessInappReceiptBodySerializer
    serializer_cls = ReceiptResponseSerializer
    service_method = 'PUT'
    query = fields.QueryDict({
        'store_id': fields.StringField(required=True, help_text=u'Идентификатор стора.'),
        'price_id': fields.StringField(required=False, help_text=u'Идентификатор продукта в сторе.'),
        'package_name': fields.StringField(required=True, help_text=u'Имя бандла.'),
        'currency': fields.StringField(required=False, help_text=u'Валюта, в которой совершалась покупка.'),
    })

    def handle(self, request, *args, **kwargs):
        context = self.get_context()
        url = self.get_url(context)
        data = self.request_service(url,
                                    method=self.service_method,
                                    data=to_json(self.request.body),
                                    headers={'Content-type': 'application/json'})
        return self.serialize(data)


class ProcessInappPaymentInitialized(PsBillingAPIProxyHandler):
    service_url = '/v1/users/inapp/payment_initialized?__uid=%(uid)s'
    hidden = True
    service_method = 'PUT'
