# -*- coding: utf-8 -*-

from mpfs.platform.fields import StringField, SerializerField, BooleanField
from mpfs.platform.serializers import BaseSerializer


class ProcessInappReceiptBodySerializer(BaseSerializer):
    visible_fields = ["receipt"]
    fields = {"receipt": StringField(required=True, help_text=u"идентификатор чека")}


class InappOrderSerializer(BaseSerializer):
    fields = {
        'order_id': StringField(help_text=u'Идентификатор ордера.', required=True),
        'user_service_id': StringField(help_text=u'Идентификатор сервиса, который был куплен.', required=False),
    }
    visible_fields = fields.keys()


class ReceiptResponseSerializer(BaseSerializer):
    fields = {
        'items': SerializerField(serializer_cls=InappOrderSerializer, many=True,
                                 help_text=u'Список ордеров по данному чеку.'),
        'trial_used': BooleanField(help_text=u'был ли использован триал', required=False),
    }
    visible_fields = fields.keys()
