# -*- coding: utf-8 -*-
from mpfs.platform.resources import NamespaceResource, adhoc
from mpfs.platform.v1.psbilling.users.handlers import SubscribeHandler, GetUserServicesHandler, \
    GetProductsForUserHandler, GetSubscriptionsStatusesForPassportHandler
from mpfs.platform.v1.psbilling.users.inapp.resources import InAppNamespace


class UsersNamespace(NamespaceResource):
    relations = {
        'subscribe': adhoc('POST', SubscribeHandler),
        'inapp': InAppNamespace,
        'services': adhoc('GET', GetUserServicesHandler),
        'productsets/(?P<key>[^/]+)/products': adhoc('GET', GetProductsForUserHandler),
        'passport/subscriptions/statuses': adhoc('GET', GetSubscriptionsStatusesForPassportHandler)
    }
