# -*- coding: utf-8 -*-

from mpfs.platform.fields import StringField, SerializerField, BooleanField, FloatField, IntegerField
from mpfs.platform.serializers import BaseSerializer


class TrialDefinitionSerializer(BaseSerializer):
    fields = {
        'period': StringField(help_text=u'Тип периода, если триал задан постоянным периодом.'),
        'periods_count': IntegerField(help_text=u'Количество периодов, если триал задан постоянным периодом'),
        'until_date': StringField(
            help_text=u'Если триал будет выдан до указанной даты, то тут это и есть та самая дата-время в формате ISO8601'),
        'price_per_user_in_month': FloatField(help_text=u'Цена продукта на время триала.', required=True)

    }
    visible_fields = fields.keys()


class TrialSerializer(BaseSerializer):
    fields = {
        'definition': SerializerField(serializer_cls=TrialDefinitionSerializer, help_text=u'Описание триала.',
                                      required=True),
    }
    visible_fields = fields.keys()


class FeatureSerializer(BaseSerializer):
    fields = {
        'description': StringField(help_text=u'Название фичи.', required=True),
        'group': StringField(help_text=u'Название группы, к которой принадлежит фича(просто ключ для группировки)'),
        'value': StringField(
            help_text=u'Если фича имеет некоторое значение, например сколько места в ней, то тут его можно передать'),
        'enabled': BooleanField(
            help_text=u'Признак того, что фича активна. Фича может быть неактивной, если такая же фича есть в других продуктах, а этом продукте ее нет'),
        'code': StringField(help_text=u'Код фичи, не зависящий от локализации'),
    }
    visible_fields = fields.keys()


class PeriodSerializer(BaseSerializer):
    fields = {
        'unit': StringField(help_text=u"Размерность периода, например, 'year'"),
        'length': IntegerField(help_text=u"Длина периода"),
    }


class StartDiscountSerializer(BaseSerializer):
    fields = {
        'period': SerializerField(serializer_cls=PeriodSerializer, help_text=u'Длина и размерность периода'),
        'periods_count': IntegerField(help_text=u'Количество периодов'),
        'price': FloatField(help_text=u'Цена на время периода'),
    }


class UserProductPriceSerializer(BaseSerializer):
    fields = {
        'price_id': StringField(help_text=u'Идентификатор цены.', required=True),
        'amount': FloatField(help_text=u'Цена', required=True),
        'currency': StringField(help_text=u'Валюта цены', required=True),
        'period': StringField(help_text=u'Период, на который покупка производится'),
        'has_active_service': BooleanField(
            help_text=u'Признак того, есть ли активные сервисы по данному продукту-цене.', required=False),
        'start_discount': SerializerField(
            serializer_cls=StartDiscountSerializer,
            help_text=u'Скидка на начале использования',
            required=False,
        ),
    }
    visible_fields = fields.keys()


class UserProductInProductSetSerializer(BaseSerializer):
    fields = {
        'product_id': StringField(help_text=u'Идентификатор продукта.', required=True),
        'product_id_family': StringField(help_text=u'Идентификатор семейства продукта.', required=True),
        'title': StringField(help_text=u'Название продукта.', required=True),
        'best_offer': BooleanField(help_text=u'Признак того, является ли продукт лучшим предложением.', required=True),
        'product_type': StringField(help_text=u'Тип продуктов.', required=True),
        'features': SerializerField(serializer_cls=FeatureSerializer, many=True,
                                    help_text=u'Список фич продукта.'),
        'trial': SerializerField(serializer_cls=TrialSerializer, help_text=u'Информация о триале.'),
        'prices': SerializerField(serializer_cls=UserProductPriceSerializer, many=True,
                                  help_text=u'Доступные цены по продукту'),
    }
    visible_fields = fields.keys()


class BoughtUserProductSerializer(BaseSerializer):
    fields = {
        'product_id': StringField(help_text=u'Идентификатор продукта.', required=True),
        'product_id_family': StringField(help_text=u'Идентификатор семейства продукта.', required=True),
        'title': StringField(help_text=u'Название продукта.', required=True),
        'best_offer': BooleanField(help_text=u'Признак того, является ли продукт лучшим предложением.', required=True),
        'product_type': StringField(help_text=u'Тип продуктов.', required=True),
        'features': SerializerField(serializer_cls=FeatureSerializer, many=True,
                                    help_text=u'Список фич продукта.'),
        'trial': SerializerField(serializer_cls=TrialSerializer, help_text=u'Информация о триале.'),
        'price': SerializerField(serializer_cls=UserProductPriceSerializer, help_text=u'цена и период продукта.'),
    }
    visible_fields = fields.keys()


class UserServiceSerializer(BaseSerializer):
    fields = {
        'service_id': StringField(help_text=u'Идентификатор услуги.', required=True),
        'readonly': BooleanField(help_text=u'Признак того, что услугу нельзя менять(отключать, например).',
                                 required=True),
        'creation_date': StringField(help_text=u'Дата-время создания услуги в формате ISO8601.', required=True),
        'subscription_until': StringField(
            help_text=u'Опциональное поле, показывает до какого времени предоставляется услуга в формате ISO8601.'),
        'status': StringField(help_text=u'Статус услуги.', required=True),
        'billing_status': StringField(help_text=u'Статус оплаты услуги.'),
        'synchronization_status': StringField(help_text=u'Статус снихронизации услуги - синхронизирована(активирована или деактивирована) или нет.'),
        'auto_prolong_enabled': BooleanField(help_text=u'Признак того, что у услуги включено автопродление.'),
        'product': SerializerField(serializer_cls=BoughtUserProductSerializer, help_text=u'Купленный продукт',
                                   required=True),
        'order_status': StringField(help_text=u'Статус заказа.', required=False),
    }
    visible_fields = fields.keys()


class GetUserServicesSerializer(BaseSerializer):
    fields = {
        'items': SerializerField(serializer_cls=UserServiceSerializer, many=True,
                                 help_text=u'Список услуг пользователя.'),
    }
    visible_fields = fields.keys()


class GetProductsForUserSerializer(BaseSerializer):
    fields = {
        'items': SerializerField(serializer_cls=UserProductInProductSetSerializer, many=True,
                                 help_text=u'Список продуктов.'),
    }
    visible_fields = fields.keys()


class GetSubscriptionsStatusesForPassportSerializer(BaseSerializer):
    fields = {
        '360': BooleanField(help_text=u'Есть подписка на Почту 360'),
        'disk': BooleanField(help_text=u'Есть подписка на Диск Про')
    }
    visible_fields = fields.keys()


class SubscribeSerializer(BaseSerializer):
    fields = {
        'order_id': StringField(help_text=u'Идентификатор заказа.', required=True),
        'payment_form_url': StringField(help_text=u'Ссылка на форму оплаты.', required=True)
    }
    visible_fields = fields.keys()
