# -*- coding: utf-8 -*-
from mpfs.platform.resources import NamespaceResource
from mpfs.platform.v1.adscim.resources import ADSCIMNamespace
from mpfs.platform.v1.albums.resources import AlbumsResource
from mpfs.platform.v1.batch.resources import BatchNamespace
from mpfs.platform.v1.case.resources import CaseApiNamespace
from mpfs.platform.v1.chaining.resources import ChainNamespace
from mpfs.platform.v1.comments.resources import CommentsResource
from mpfs.platform.v1.data.resources import DataNamespace
from mpfs.platform.v1.disk.resources import DiskNamespace
from mpfs.platform.v1.notes.resources import NotesResource
from mpfs.platform.v1.notifier.resources import NotifierNamespace
from mpfs.platform.v1.personality.resources import PersonalityNamespace
from mpfs.platform.v1.psbilling.resources import PsBillingNamespace
from mpfs.platform.v1.schema.resources import SchemaIndexResource
from mpfs.platform.v1.telemost.resources import TelemostNamespace


class V1Namespace(NamespaceResource):
    relations = {
        'disk': DiskNamespace,
        'personality': PersonalityNamespace,
        'schema': SchemaIndexResource,
        'data': DataNamespace,
        'case': CaseApiNamespace,
        'batch': BatchNamespace,
        'chaining': ChainNamespace,
        'commentaries/.+': CommentsResource,
        'notes/(?P<proxied_path>.+)': NotesResource,
        'notifier': NotifierNamespace,
        'albums': AlbumsResource,
        'telemost': TelemostNamespace,
        'adscim': ADSCIMNamespace,
        'psbilling': PsBillingNamespace
    }
