# -*- coding: utf-8 -*-
import re
from mpfs.platform.resources import BaseResource, res
from mpfs.platform.v1.schema.handlers import (GetSchemaIndexHandler, GetSchemaApiHandler, GetProtoIndexHandler,
                                              GetProtoFileHandler)


class SchemaIndexResource(BaseResource):
    """Документация API"""
    api_version = 'v1'
    resources = map(lambda p: re.compile(p, re.IGNORECASE), [
        '^/v1/disk$',
        '^/v1/disk/resources.*',
        '^/v1/disk/public/resources.*',
        '^/v1/disk/trash/resources.*',
        '^/v1/disk/operations.*',
    ])

    internal_resources = map(lambda p: re.compile(p, re.IGNORECASE), [
        '^/v1/disk/lenta/resources.*',
        '^/v1/disk/lenta/blocks/{lenta_block_id}.*',
        '^/v1/disk/lenta/report-bad-block.*',

        # '^/v1/disk/event-history.*',  # пока ломает нам полигон
        '^/v1/disk/partners.*',
        '^/v1/disk/wopi/files/{resource_id}.*',
        '^/v1/disk/notifications/subscriptions/app.*',
        '^/v1/disk/photoslice.*',
        '^/v1/disk/partners.*',
        '^/v1/disk/video/streams.*',
        '^/v1/disk/public/video.*',
        '^/v1/disk/photoalbums.*',
        '^/v1/disk/photounlim/resources/last-modified$',
        '^/v1/disk/photounlim/resources/download$',
        '^/v1/disk/organizations.*',
        '^/v1/disk/docs.*',
        # '^/v1/disk/billing/.*',  # пока ломает нам полигон

        '^/v1/disk/clients/.*',

        '^/v1/notifier/.*',

        '^/v1/data/{context}/databases.*',
        '^/v1/data/subscriptions/web.*',
        '^/v1/data/subscriptions/app.*',
        '^/v1/data/subscriptions/callback.*',

        '^/v1/personality/profile/addresses.*',
        '^/v2/personality/profile/addresses.*',
        '^/v1/personality/profile/events/flights/actual.*',
        '^/v1/personality/profile/ya-tickets/orders.*',

        '^/v1/batch.*',

        '^/v1/chaining.*',

        '^/v1/case/qa/disk/shared-folders.*',

        # clients/ - слэш в конце чтобы исключить /v1/telemost/clients
        '^/v1/telemost/clients/.*',
        '^/v1/telemost/conferences.*',
        '^/v1/telemost/yandex-team.*',
        '^/v1/telemost/stat/log$',
        '^/v2/telemost/conferences.*',
        '^/v2/telemost/users.*',
        '^/v2/telemost/chats.*',
    ])

    relations = {
        'GET': GetSchemaIndexHandler,
        'resources/(?P<path>.+)': res(relations={'GET': GetSchemaApiHandler}, api_version=api_version,
                                      resources=resources, internal_resources=internal_resources),
        'protobuf/cloud-api\.proto': res(relations={'GET': GetProtoIndexHandler},
                                         resources=resources, internal_resources=internal_resources),
        'protobuf/(?P<path>.+)\.proto': res(relations={'GET': GetProtoFileHandler},
                                            resources=resources, internal_resources=internal_resources),
    }
