# -*- coding: utf-8 -*-
from mpfs.platform.exceptions import (
    BadRequestError,
    NotFoundError,
    GoneError,
    ForbiddenError,
    ConflictError,
    ServiceUnavailableError,
)


class TelemostPasswordTooLongError(BadRequestError):
    description = 'Password too long (max length is %(max_length)s).'
    message = u'Пароль слишком длинный (максимальная длина: %(max_length)s).'


class TelemostPasswordTypeError(BadRequestError):
    description = 'Password should be string, but got %(type)s).'
    message = u'Пароль должен быть строкой, а не %(type)s).'


class TelemostConferenceNotFoundError(NotFoundError):
    description = 'Conference not found.'
    message = u'Видео встреча не найдена.'


class TelemostInviteLinkExpiredError(GoneError):
    description = 'Conference\'s link expired.'
    message = u'Время жизни пригласительной ссылки истекло.'


class BadBodyError(BadRequestError):
    description = 'Bad body format: %(details)s).'
    message = u'Некорректное тело: %(details)s).'


class TelemostClientBadRequest(BadRequestError):
    description = 'Bad request from client'
    message = u'Некорректный запрос'


class TelemostActiveSessionNotFoundError(NotFoundError):
    description = 'Active session not found.'
    message = u'Активная сессия не найдена.'


class TelemostPeerTokenInvalidError(ForbiddenError):
    description = 'Peer token is invalid'
    message = u'Некорректный токен пользователя'


class TelemostSessionAlreadyDisconnectedError(ConflictError):
    description = 'Session has been disconnected already'
    message = u'Сессия уже отключена'


class TelemostTooManyUsersError(ConflictError):
    description = 'Too many users in conference'
    message = u'Превышено максимальное число активный пользователей в видеовстрече'


class TelemostServiceTemporaryOverloaded(ServiceUnavailableError):
    description = 'Telemost is unavailable, we’re working on the fix, please try again later.'
    message = u'Сейчас сервис перегружен, но мы уже работаем над этой проблемой.'
