# -*- coding: utf-8 -*-
import collections

from mpfs.platform.resources import NamespaceResource, adhoc, BaseResource
from mpfs.platform.v1.telemost.handlers import (
    CreateConferenceHandler,
    GetConferenceConnectionHandler,
    LogStatisticsHandler,
    GetConferenceAuthorizationURIHandler,
    GetTelemostClientsInstallerHandler,
    PutTelemostFOSHandler,
    GetTelemostClientsInstallerWithAutologonHandler,
    GetExperimentsHandler, BandwidthBenchmarkHandler,
)


class ClientsResource(BaseResource):
    """Работа с клиентами ПО"""
    relations = collections.OrderedDict([
        ('win/installer', adhoc('GET', GetTelemostClientsInstallerWithAutologonHandler)),
        ('(?P<platform_id>[^/]+)/installer', adhoc('GET', GetTelemostClientsInstallerHandler)),
        ('fos', adhoc('PUT', PutTelemostFOSHandler)),
    ])


class ExperimentsResource(BaseResource):
    """Получение параметров экспериментов"""
    relations = {
        'GET': GetExperimentsHandler
    }


class TelemostNamespace(NamespaceResource):
    relations = {
        'conferences': adhoc('POST', CreateConferenceHandler),
        'conferences/(?P<uri>[^/]+)/connection': adhoc('GET', GetConferenceConnectionHandler),
        'yandex-team/conferences/(?P<uri>[^/]+)/authorize': adhoc('GET', GetConferenceAuthorizationURIHandler),
        'stat/log': adhoc('POST', LogStatisticsHandler),
        'stat/ping': adhoc('POST', BandwidthBenchmarkHandler),
        'clients': ClientsResource,
        'experiments': ExperimentsResource,
    }
