# -*- coding: utf-8 -*-
from mpfs.platform.fields import StringField, UrlField, BooleanField, JsonObjectField, ListField
from mpfs.platform.serializers import BaseSerializer


class ConferenceSerializer(BaseSerializer):
    visible_fields = ['uri', 'conf_server', 'conf_id', 'conf_pwd', 'xmpp_user_id', 'xmpp_password', 'xmpp_muc',
                      'xmpp_domain', 'display_name', 'connection_config', 'room_config']
    fields = {
        'uri': UrlField(help_text=u'Ссылка на подключение к конференции.'),
        'conf_server': UrlField(help_text=u'Ссылка на подключение к серверу конференций.'),
        'conf_id': StringField(help_text=u'Идентификатор создаваемой конференции.'),
        'conf_pwd': StringField(help_text=u'Пароль для создавамой конференции.'),
        'display_name': StringField(help_text=u'Публичное имя пользователя.'),
        'xmpp_user_id': StringField(help_text=u'Имя пользователя для авторизации на сервере конференций.'),
        'xmpp_password': StringField(help_text=u'Пароль для авторизации на сервере конференций.'),
        'xmpp_muc': StringField(help_text=u'Хост сервера конференций для работы в режиме Multi User Chat.'),
        'xmpp_domain': StringField(help_text=u'Domain сервера конференций.'),
        'connection_config': JsonObjectField(help_text=u'Клиентская конфигурация подключения', source='client_configuration.connection_config'),
        'room_config': JsonObjectField(help_text=u'Клиентская конфигурация для комнат', source='client_configuration.room_config')
    }


class ConferenceConnectionSerializer(BaseSerializer):
    visible_fields = ['uri', 'conf_server', 'conf_id', 'conf_pwd', 'xmpp_user_id', 'xmpp_password', 'xmpp_muc',
                      'xmpp_domain', 'display_name', 'connection_config', 'room_config']
    fields = {
        'uri': UrlField(help_text=u'Ссылка на подключение к конференции.'),
        'conf_server': UrlField(help_text=u'Ссылка на подключение к серверу конференций.'),
        'conf_id': StringField(help_text=u'Идентификатор создаваемой конференции.'),
        'conf_pwd': StringField(help_text=u'Пароль для создавамой конференции.'),
        'display_name': StringField(help_text=u'Публичное имя пользователя.'),
        'xmpp_user_id': StringField(help_text=u'Имя пользователя для авторизации на сервере конференций.'),
        'xmpp_password': StringField(help_text=u'Пароль для авторизации на сервере конференций.'),
        'xmpp_muc': StringField(help_text=u'Хост сервера конференций для работы в режиме Multi User Chat.'),
        'xmpp_domain': StringField(help_text=u'Domain сервера конференций.'),
        'connection_config': JsonObjectField(help_text=u'Клиентская конфигурация подключения', source='client_configuration.connection_config'),
        'room_config': JsonObjectField(help_text=u'Клиентская конфигурация для комнат', source='client_configuration.room_config')
    }


class CreateConferenceBodySerializer(BaseSerializer):
    visible_fields = ['password', 'staff_only']
    fields = {
        'password': StringField(help_text=u'Пароль для создаваемой конференции.'),
        'staff_only': BooleanField(default=False,
                                   help_text=u'Создать конференцию только для сотрудников Яндекс.'),
        'calendar_event_id': StringField(help_text=u'Идентификатор события календаря, из которого создана конференция.'),
    }


class AuthorizationURISerializer(BaseSerializer):
    visible_fields = ['uri']
    fields = {
        'uri': UrlField(help_text=u'Ссылка для авторизации и подключения к конференции.'),
    }


class StatReportBodySerializer(BaseSerializer):
    visible_fields = ['stats_report']
    fields = {
        'stats_report': JsonObjectField(max_size=30720,
                                        help_text=u'Отчет о видео встрече.'),
    }


class GetConferenceConnectionBodySerializer(BaseSerializer):
    visible_fields = ['password']
    fields = {
        'password': StringField(help_text=u'Пароль для конференции.'),
    }


class FOSBodySerializer(BaseSerializer):
    fields = {
        'fos_support_text': StringField(help_text=u'Текст обращения пользователя из формы обратной связи.'),
        'debug_info': StringField(help_text=u'Дебаг информация для разработчиков.')
    }
    visible_fields = fields.keys()


class ExperimentsSerializer(BaseSerializer):
    fields = {
        'uas_exp_flags': ListField(item_field_type=JsonObjectField,
                                   help_text=u'Список параметров экспериментов, полученых от UaaS'),
    }
    visible_fields = fields.keys()
