# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.core.office.auth import check_access_token
from mpfs.platform.auth import BaseAuth
from mpfs.platform.common import PlatformClient, PlatformUser

OFFICE_PLATFORM_CLIENT_ID = settings.office['platform_client_id']
OFFICE_PLATFORM_CLIENT_NAME = settings.office['platform_client_name']


class WOPIAuth(BaseAuth):
    """Расшифровывает access_token и проверяет не протух ли он."""
    def authorize(self, request):
        access_token = request.args.get('access_token', None)

        if access_token:
            token_data = check_access_token(access_token)
            if token_data:
                uid, resource_id, expires = token_data

                client = PlatformClient()
                client.ip = request.remote_addr
                client.id = OFFICE_PLATFORM_CLIENT_ID
                client.name = OFFICE_PLATFORM_CLIENT_NAME
                client.token = access_token
                client.is_yandex = True
                request.client = client

                user = PlatformUser()
                user.uid = uid
                request.user = user

                return True
        return False
