# -*- coding: utf-8 -*-
from mpfs.platform import exceptions


class WopiLockMismatchError(exceptions.ConflictError):
    description = 'Lock mismatch.'
    message = u'Файл заблокирован.'

    def __init__(self, lock_value, *args, **kwargs):
        kwargs['headers'] = {
            'X-WOPI-Lock': lock_value
        }
        super(WopiLockMismatchError, self).__init__(*args, **kwargs)


class WopiNotAllowedActionError(WopiLockMismatchError):
    def __init__(self, *args, **kwargs):
        super(WopiNotAllowedActionError, self).__init__('', *args, **kwargs)
