# -*- coding: utf-8 -*-
from mpfs.common.static import tags
from mpfs.core.office.auth import parse_access_token
from mpfs.platform.permissions import BasePlatformPermission


class AccessResourceIdPermission(BasePlatformPermission):
    """Проверяет, что access_token имеет право на доступ к файлу с resource_id."""
    def has_permission(self, request):
        if request.mode == tags.platform.INTERNAL:
            # Своим всё можно.
            return True
        _, resource_id, _ = parse_access_token(request.client.token)
        return resource_id == request.kwargs.get('resource_id')
