# -*- coding: utf-8 -*-

from mpfs.platform.resources import BaseResource

from mpfs.platform.v1.wopi import handlers


class FileResource(BaseResource):
    relations = {
        'GET': handlers.CheckFileInfoHandler,
        'POST': handlers.PostFileHandler
    }


class FilesResource(BaseResource):
    relations = {
        '(?P<resource_id>[^/]+)': FileResource
    }


class WopiNamespace(BaseResource):
    hidden = True
    relations = {
        'files': FilesResource,
    }
