# -*- coding: utf-8 -*-

from mpfs.platform import fields
from mpfs.platform.serializers import BaseSerializer


class CheckFileInfoSerializer(BaseSerializer):
    fields = {
        'BaseFileName': fields.StringField(required=True, help_text=u'Имя файла.'),
        'OwnerId': fields.StringField(required=True, help_text=u'Идентификатор владельца файла.'),
        'Size': fields.IntegerField(required=True, help_text=u'Размер файла в байтах.'),
        'Version': fields.StringField(required=True, help_text=u'Идентификатор версии файла.'),
        'SupportsLocks': fields.BooleanField(required=False, help_text=u'Доступна ли поддержка локов.'),
        'UserCanWrite': fields.BooleanField(required=False, help_text=u'Имеет ли пользователь права на редактирование.'),
        'SupportsUpdate': fields.BooleanField(required=False, help_text=u'Доступна ли поддержка обновлений файла.'),
        'SupportsRename': fields.BooleanField(required=False, help_text=u'Доступно ли переименование файла.'),
        'SupportsCoauth': fields.BooleanField(required=True, help_text=u'Доступно ли совместное редактирование.'),
        'UserCanRename': fields.BooleanField(required=False, help_text=u'Имеет ли пользователь права на переименование файла.'),

        'AllowExternalMarketplace': fields.BooleanField(required=True, help_text=u'Разрешить ли подключение внешних сервисов.'),
        'CloseButtonClosesWindow': fields.BooleanField(required=True, help_text=u'Закрывать ли окно браузера при закрытии документа.'),
        'FileNameMaxLength': fields.IntegerField(required=True, help_text=u'Максимальная длина имени файла.'),

        'BreadcrumbBrandName': fields.StringField(required=False, help_text=u'Название сервиса, из которого открыт документ.'),
        'BreadcrumbBrandUrl': fields.StringField(required=True, help_text=u'Ссылка на сервис, из которого открыт документ.'),
        'BreadcrumbDocName': fields.StringField(required=True, help_text=u'Имя файла.'),
        'BreadcrumbFolderName': fields.StringField(required=False, help_text=u'Имя папки, в которой располагается файл.'),
        'BreadcrumbFolderUrl': fields.StringField(required=True, help_text=u'Ссылка на папку в сервисе, из которого открыт документ.'),

        'DownloadUrl': fields.StringField(required=True, help_text=u'Ссылка на загрузку редактируемого файла.'),
        'UserId': fields.StringField(required=True, help_text=u'Имя пользователя.'),
        'UserFriendlyName': fields.StringField(required=True, help_text=u'Удобочитаемое имя пользователя.'),
        'UserCanNotWriteRelative': fields.StringField(required=True, help_text=u'Запретить PutRelativeFile.'),

        'PostMessageOrigin': fields.StringField(required=False, help_text=u'Домен, с которым разрешено обмениваться PostMessages.'),
        'FileSharingPostMessage': fields.BooleanField(help_text=u'Показывать Share UI контрол.'),
    }


class RenameFileSerializer(BaseSerializer):
    fields = {
        'Name': fields.StringField(required=True, help_text=u'Новое имя файла.'),
    }
