# -*- coding: utf-8 -*-
from mpfs.platform.resources import NamespaceResource, BaseResource, adhoc
from mpfs.platform.v2.personality.handlers import (ListNewAddressesHandler,
                                                   GetNewAddressHandler, SaveNewAddressHandler, DeleteNewAddressHandler,
                                                   TouchNewAddressHandler, TagNewAddressHandler, UntagNewAddressHandler,
                                                   PatchNewAddressHandler, CreateNewAddressHandler)


class NewAddressResource(BaseResource):
    """Адрес пользователя"""
    relations = {
        'GET': GetNewAddressHandler,
        'DELETE': DeleteNewAddressHandler,
        'PUT': SaveNewAddressHandler,
        'PATCH': PatchNewAddressHandler,

        'touch': adhoc('POST', TouchNewAddressHandler),
        'tag': adhoc('PUT', TagNewAddressHandler),
        'untag': adhoc('PUT', UntagNewAddressHandler),
    }


class NewAddressesCollection(BaseResource):
    """Адреса пользователя"""
    relations = {
        'GET': ListNewAddressesHandler,
        'POST': CreateNewAddressHandler,
        '(?P<address_id>[^/]+)': NewAddressResource,
    }


class ProfileResource(BaseResource):
    """Профиль пользователя v2"""
    relations = {
        'addresses': NewAddressesCollection,
    }


class PersonalityNamespace(NamespaceResource):
    """API Персонализации v2"""
    relations = {
        'profile': ProfileResource,
    }
