# -*- coding: utf-8 -*-
from mpfs.platform import fields
from mpfs.platform.serializers import BaseSerializer, ListSerializer


class DataApiNewAddressPatchSerializer(BaseSerializer):
    visible_fields = ['title', 'tags', 'latitude', 'longitude', 'address_line', 'address_line_short',
                      'last_used', 'entrance_number', 'custom_metadata']

    fields = {
        'title': fields.StringField(pbid=1, help_text=u'Название адреса'),
        'latitude': fields.FloatField(pbid=2, help_text=u'Широта'),
        'longitude': fields.FloatField(pbid=3, help_text=u'Долгота'),

        'tags': fields.ListField(pbid=4, help_text=u'Список тэгов'),

        'address_line': fields.StringField(pbid=5, help_text=u'Полная запись адреса'),
        'address_line_short': fields.StringField(pbid=6, help_text=u'Короткая запись адреса'),

        'last_used': fields.DateTimeToTSField(pbid=7, milliseconds=True, help_text=u'Время последнего использования адреса'),

        'entrance_number': fields.StringField(pbid=8, help_text=u'Номер подъезда'),
        'custom_metadata': fields.StringField(pbid=9, help_text=u'json с кастомными метаданными'),
    }


class DataApiNewAddressSerializer(BaseSerializer):
    visible_fields = ['address_id', 'title', 'tags', 'latitude', 'longitude', 'address_line', 'address_line_short',
                      'created', 'modified', 'last_used', 'mined_attributes', 'entrance_number', 'custom_metadata']

    fields = {
        'address_id': fields.StringField(pbid=1, help_text=u'Идентификатор адреса'),

        'title': fields.StringField(required=True, pbid=2, help_text=u'Название адреса'),
        'latitude': fields.FloatField(required=True, pbid=3, help_text=u'Широта'),
        'longitude': fields.FloatField(required=True, pbid=4, help_text=u'Долгота'),

        'tags': fields.ListField(pbid=5, help_text=u'Список тэгов'),

        'address_line': fields.StringField(pbid=6, help_text=u'Полная запись адреса'),
        'address_line_short': fields.StringField(pbid=7, help_text=u'Короткая запись адреса'),

        'created': fields.DateTimeToTSField(pbid=8, milliseconds=True, help_text=u'Время создания адреса'),
        'modified': fields.DateTimeToTSField(pbid=9, milliseconds=True, help_text=u'Время создания адреса'),
        'last_used': fields.DateTimeToTSField(pbid=10, milliseconds=True, help_text=u'Время последнего использования адреса'),

        'mined_attributes': fields.ListField(pbid=11, help_text=u'Список атрибутов, которые были извлечены автоматически'),

        'entrance_number': fields.StringField(pbid=12, help_text=u'Номер подъезда'),
        'custom_metadata': fields.StringField(pbid=13, help_text=u'json с кастомными метаданными'),
    }


class DataApiNewAddressListSerializer(ListSerializer):
    visible_fields = ['total', 'limit', 'offset', 'items', '_links']
    fields = {
        'items': fields.SerializerField(DataApiNewAddressSerializer, required=True, many=True, source='items', pbid=1),
    }
