# coding=utf-8

from mpfs.platform import fields
from mpfs.platform.rate_limiters import PerUserRateLimiter
from mpfs.platform.utils import quote_string
from mpfs.platform.v1.psbilling.handlers import PsBillingAPIProxyHandler
from mpfs.platform.v2.psbilling.users.serializers import GetProductsForUserSerializer


class GetProductsForUserHandler(PsBillingAPIProxyHandler):
    serializer_cls = GetProductsForUserSerializer
    service_method = 'GET'
    service_url = '/v3/productsets/%(key)s/products?__uid=%(uid)s'
    resp_status_code = 200

    kwargs = fields.QueryDict({
        'key': fields.StringField(required=True, help_text=u'Ключ продукт сета.')
    })

    query = fields.QueryDict({
        'package_name': fields.StringField(required=False,
                                           help_text=u'Имя приложения, в котором осуществляется покупка.'),
        'payload_type': fields.StringField(required=False,
                                           help_text=u'Тип возвращаемого пейлоада.'),
        'payload_version': fields.IntegerField(required=False,
                                               help_text=u'Версия возвращаемого пейлоада.'),
        'promo_activation': fields.BooleanField(required=False, default=None,
                                                help_text=u'Запросить догоняющую скидку.'),
        'promoActivation': fields.BooleanField(
            required=False, default=None,
            help_text=u'Запросить догоняющую скидку (легаси опечатка не надо пользоваться этим параметром)'
        ),
        'currency': fields.StringField(required=False,
                                       help_text=u'Валюта, в которой будут отображаться цены на продукты.'),
    })
    rate_limiter = PerUserRateLimiter('cloud_api_user_psbilling_user_products')

    def get_url(self, context=None):
        url = super(GetProductsForUserHandler, self).get_url(context=context)
        params = {}
        package_name = self.request.query.get('package_name', None)
        if package_name:
            params['packageName'] = package_name

        if self._is_need_legacy_mobile():
            payload_type = 'mobile'
            payload_version = '0'
        else:
            payload_type = self.request.query.get('payload_type', None)
            payload_version = self.request.query.get('payload_version', None)

        if payload_type is not None:
            params['payload_type'] = payload_type
        if payload_version is not None:
            params['payload_version'] = payload_version
        promo_activation = self.request.query.get('promo_activation')
        if promo_activation is None:
            promo_activation = self.request.query.get('promoActivation', None)
        if promo_activation is not None:
            params['promo_activation'] = str(promo_activation).lower()

        currency = self.request.query.get('currency', None)
        if currency:
            params['currency'] = currency

        return self.patch_url_params(url, params)

    def request_service(self, url, method=None, headers=None, data=None, service=None):
        response = super(GetProductsForUserHandler, self).request_service(
            url,
            method=method,
            headers=headers,
            data=data,
            service=service
        )

        if self._is_need_legacy_mobile() and 'active_promo' in response and 'payload' in response['active_promo']:
            response['active_promo']['mobile_payload'] = response['active_promo']['payload']
            del response['active_promo']['payload']

        return response

    def _is_need_legacy_mobile(self):
        payload_type = self.request.query.get('payload_type', None)
        payload_version = self.request.query.get('payload_version', None)
        return not payload_type and payload_version is None
