# -*- coding: utf-8 -*-

from mpfs.platform.fields import SerializerField, StringField
from mpfs.platform.serializers import BaseSerializer
from mpfs.platform.v1.psbilling.users.serializers import UserProductInProductSetSerializer, UserServiceSerializer


class PromoSerializer(BaseSerializer):
    fields = {
        'key': StringField(help_text=u'Идентификатор продукта.', required=True),
        'title': StringField(help_text=u'Название акции.', required=False),
        'active_until_date': StringField(help_text=u'Дата окончания промо.', required=False),
        'mobile_payload': StringField(help_text=u'Информация о промо акции для мобильных устройств (deprecated).', required=False),
        'payload': StringField(help_text=u'Информация о промо акции.', required=False)
    }
    visible_fields = fields.keys()


class GetProductsForUserSerializer(BaseSerializer):
    fields = {
        'items': SerializerField(serializer_cls=UserProductInProductSetSerializer, many=True,
                                 help_text=u'Список продуктов.'),
        'current_subscription': SerializerField(serializer_cls=UserServiceSerializer,
                                                help_text=u'Текущая действующая подписка.',
                                                required=False),
        'order_status': StringField(help_text=u'Статус заказа.', required=False),
        'active_promo': SerializerField(serializer_cls=PromoSerializer, required=False, help_text=u'Активная акция.'),
    }
    visible_fields = fields.keys()
