# -*- coding: utf-8 -*-

from mpfs.platform.resources import (
    NamespaceResource,
    adhoc,
)
from mpfs.platform.v1.telemost.handlers import GetExperimentsHandler
from mpfs.platform.v2.disk.resources import ResourcesResource
from mpfs.platform.v2.personality.resources import PersonalityNamespace
from mpfs.platform.v2.psbilling.resources import PsBillingNamespace
from mpfs.platform.v2.telemost.handlers import (
    CreateConferenceHandler,
    GetUserInfoHandler,
    GetConferenceConnectionHandler,
    LinkCalendarEventHandler,
    GetConferencePeersHandler,
    GetConferenceInfoHandler,
    LeaveRoomHandler,
    GetUserFeatureTogglesHandler,
    CreateChatHandler,
    JoinToChatHandler,
    GetChatHistoryHandler,
    MuteMicrophoneCommandHandler,
    MuteCameraCommandHandler,
    MuteDesktopCommandHandler,
    MuteAllMicrophonesCommandHandler,
    MuteAllCamerasCommandHandler,
    MuteAllDesktopsCommandHandler,
    SetRoleCommandHandler,
    CreateBroadcastHandler,
    StartStreamHandler,
    StopStreamHandler,
    GetStreamConnectionHandler,
    BillingBroadcastEnableHandler,
    BillingBroadcastDisableHandler,
)


class DiskResource(NamespaceResource):
    relations = {
        'resources': ResourcesResource
    }


class TelemostConferenceCommandsNamespace(NamespaceResource):
    relations = {
          'mute-microphone': adhoc('POST', MuteMicrophoneCommandHandler),
          'mute-camera': adhoc('POST', MuteCameraCommandHandler),
          'mute-desktop': adhoc('POST', MuteDesktopCommandHandler),
          'mute-all-microphones': adhoc('POST', MuteAllMicrophonesCommandHandler),
          'mute-all-cameras': adhoc('POST', MuteAllCamerasCommandHandler),
          'mute-all-desktops': adhoc('POST', MuteAllDesktopsCommandHandler),
          'set-user-role': adhoc('POST', SetRoleCommandHandler),
    }


class TelemostConferenceBroadcastNamespace(NamespaceResource):
    relations = {
        'PUT': CreateBroadcastHandler,
        '(?P<broadcast_uri>[^/]+)/start': adhoc('POST', StartStreamHandler),
        '(?P<broadcast_uri>[^/]+)/stop': adhoc('POST', StopStreamHandler),
    }


class TelemostViewerNamespace(NamespaceResource):
    relations = {
        'connection': adhoc('GET', GetStreamConnectionHandler),
    }


class TelemostBillingBroadcastNamespace(NamespaceResource):
    relations = {
        'enable': adhoc('PUT', BillingBroadcastEnableHandler),
        'disable': adhoc('PUT', BillingBroadcastDisableHandler),
    }


class TelemostConferenceDetailsNamespace(NamespaceResource):
    relations = {
        'GET': GetConferenceInfoHandler,
        'connection': adhoc('GET', GetConferenceConnectionHandler),
        'peers': adhoc('PUT', GetConferencePeersHandler),
        'link-calendar-event': adhoc('POST', LinkCalendarEventHandler),
        'commands': TelemostConferenceCommandsNamespace,
        'broadcast': TelemostConferenceBroadcastNamespace,
    }


class ExperimentsResource(NamespaceResource):
    """Получение параметров экспериментов"""
    relations = {
        'GET': GetExperimentsHandler,
    }


class ChatResource(NamespaceResource):
    """Поддержка чатов в Телемосте"""
    relations = {
        'PUT': CreateChatHandler,
        'join': adhoc('PUT', JoinToChatHandler),
        'history': adhoc('GET', GetChatHistoryHandler),
    }


class TelemostNamespace(NamespaceResource):
    relations = {
        'conferences': adhoc('POST', CreateConferenceHandler),
        'conferences/(?P<uri>[^/]+)': TelemostConferenceDetailsNamespace,
        'users/me': adhoc('GET', GetUserInfoHandler),
        'rooms/(?P<room_id>[^/]+)/leave': adhoc('POST', LeaveRoomHandler),
        'clients/features': adhoc('GET', GetUserFeatureTogglesHandler),
        'experiments': ExperimentsResource,
        'chats/(?P<room_id>[^/]+)': ChatResource,
        'broadcast/(?P<broadcast_uri>[^/]+)': TelemostViewerNamespace,
        'billing/broadcast': TelemostBillingBroadcastNamespace,
    }


class V2Namespace(NamespaceResource):
    relations = {
        'personality': PersonalityNamespace,
        'disk': DiskResource,
        'telemost': TelemostNamespace,
        'psbilling': PsBillingNamespace
    }
