# -*- coding: utf-8 -*-
from mpfs.platform.exceptions import (
    BadRequestError,
    ForbiddenError,
    UnauthorizedError)
from mpfs.platform.v2.telemost.serializers import (
    TelemostForbiddenErrorWithLinkSerializer,
    TelemostInviteLinkNotComeSerializer)


class TelemostBadRequestError(BadRequestError):
    description = 'Failed to process Telemost API request.'
    message = u'Не удалось выполнить успешно запрос в Telemost API.'


class TelemostYaTeamTokenAccessError(ForbiddenError):
    error_serializer_cls = TelemostForbiddenErrorWithLinkSerializer
    message = u'Ошибка при валидации пользовательского токена.'


class TelemostYaTeamConferenceForbiddenError(ForbiddenError):
    message = u'Доступ в yandex-team встречу запрещен.'


class TelemostUnauthorizedError(UnauthorizedError):
    error_serializer_cls = TelemostForbiddenErrorWithLinkSerializer
    message = u'yandex-team встречи доступны только для авторизированных пользователей.'


class TelemostInviteLinkNotComeError(ForbiddenError):
    error_serializer_cls = TelemostInviteLinkNotComeSerializer
    description = 'Conference\'s link not come.'
    message = u'Встреча еще не началась.'

    def __init__(self, inner_exception, **kwargs):
        super(TelemostInviteLinkNotComeError, self).__init__(inner_exception, **kwargs)
        self.start_event_time = inner_exception.data['start_event_time']


class TelemostForbiddenToPrivateError(ForbiddenError):
    description = 'Access to the private conference is forbidden.'
    message = u'Доступ в закрытую встречу запрещен.'


class TelemostStreamNotStartedError(ForbiddenError):
    description = 'The stream for the specified broadcast is not running.'
    message = u'Стрим для указанной трансляции не запущен.'


class TelemostBroadcastLinkExpiredError(ForbiddenError):
    description = 'The link to the stream is no longer relevant.'
    message = u'Ссылка на стрим больше не актуальна.'


class TelemostNoSuchBroadcastCreatedError(ForbiddenError):
    description = 'The specified broadcast not found.'
    message = u'Указанная трансляция не найдена.'


class TelemostInvalidTranslatorTokenError(ForbiddenError):
    description = 'Invalid translator token specified.'
    message = u'Указан неверный токен транслятора.'


class TelemostNoSuchUserInConferenceError(ForbiddenError):
    description = 'The specified user not found.'
    message = u'Указанный пользователь не найден.'

class TelemostForbiddenAccessToCreateBroadcastError(ForbiddenError):
    description = 'Unable to create a broadcast.'
    message = u'Невозможно создать трансляцию.'

class TelemostForbiddenAccessToStartBroadcastError(ForbiddenError):
    description = 'The specified user not found.'
    message = u'Unable to start the broadcast.'
