# -*- coding: utf-8 -*-
from mpfs.platform.fields import UrlField, StringField, SerializerField, ListField, JsonObjectField, BooleanField, IntegerField
from mpfs.platform.serializers import BaseSerializer, ErrorWithContextSerializer
from mpfs.platform.v1.disk.serializers import FeatureToggleSerializer


class CreateChatSerializer(BaseSerializer):
    visible_fields = ['chat_path']
    fields = {
        'chat_path': StringField(help_text=u'Путь до чата без указания хоста.'),
    }


class JoinToChatSerializer(BaseSerializer):
    visible_fields = ['chat_path']
    fields = {
        'chat_path': StringField(help_text=u'Путь до чата без указания хоста.'),
    }


class GetChatHistorySerializer(BaseSerializer):
    visible_fields = ['timestamp_from', 'timestamp_to', 'history']
    fields = {
        'timestamp_from': IntegerField(help_text=u'Начальный timestamp блока истории.'),
        'timestamp_to': IntegerField(help_text=u'Конечный timestamp блока истории.'),
        'history': StringField(help_text=u'Отформатированный блок истории чата.'),
    }


class ConferenceConnectionSerializer(BaseSerializer):
    visible_fields = ['uri', 'ws_uri', 'room_id', 'safe_room_id', 'peer_id', 'client_configuration', 'peer_token',
                      'media_session_id', 'conference_state']
    fields = {
        'uri': UrlField(help_text=u'Ссылка на подключение к конференции.'),
        'wc_uri': UrlField(help_text=u'Ссылка на WebSocket для XIVA.'),
        'room_id': StringField(help_text=u'Идентификатор комнаты конференции.'),
        'safe_room_id': StringField(help_text=u'Безопасный для логирования идентификатор комнаты конференции.'),
        'peer_id': StringField(help_text=u'Идентификатор пользователя.'),
        'media_session_id': StringField(help_text=u'Идентификатор медиа-сессии.'),
        'peer_token': StringField(help_text=u'Токен участника конференции.'),
        'client_configuration': JsonObjectField(help_text=u'Клиентская конфигурация подключения.'),
        'conference_state': JsonObjectField(help_text=u'Состояние конференции.'),
    }


class ConferenceInfoSerializer(BaseSerializer):
    visible_fields = ['uri', 'room_id', 'safe_room_id', 'is_yandex_team', 'conference_state']
    fields = {
        'uri': UrlField(help_text=u'Ссылка на подключение к конференции.'),
        'room_id': StringField(help_text=u'Идентификатор комнаты конференции.'),
        'safe_room_id': StringField(help_text=u'Безопасный для логирования идентификатор комнаты конференции.'),
        'is_yandex_team': BooleanField(help_text=u'Является ли встреча yandex-team встречей.'),
        'conference_state': JsonObjectField(help_text=u'Состояние конференции.'),
    }


class PeerIDsBodySerializer(BaseSerializer):
    visible_fields = ['peers_ids']
    fields = {
        'peers_ids': ListField(help_text=u'Список peer_id, для которых запрашивается информация.'),
    }


class PeerSerializer(BaseSerializer):
    visible_fields = ['uid', 'display_name', 'avatar_url', 'is_default_avatar', 'peer_id', 'role']
    fields = {
        'uid': StringField(help_text=u'Идентификатор пользователя из Паспорта.'),
        'display_name': StringField(help_text=u'Отображаемое имя.'),
        'avatar_url': UrlField(help_text=u'Ссылка на аватарку.'),
        'is_default_avatar': BooleanField(help_text=u'Если true, то аватар является дефолтным.'),
        'peer_id': StringField(help_text=u'Идентификатор пользователя.'),
        'role': StringField(help_text=u'Роль пользователя.'),
    }


class PeerListSerializer(BaseSerializer):
    visible_fields = ['items']
    fields = {
        'items': SerializerField(PeerSerializer, many=True, help_text=u'Список пользователей'),
    }


class UserInfoSerializer(BaseSerializer):
    visible_fields = ['uid', 'display_name', 'avatar_url', 'is_default_avatar', 'login', 'country', 'is_yandex_staff',
                      'broadcast_allowed', 'broadcast_feature_enabled']
    fields = {
        'uid': StringField(help_text=u'Идентификатор пользователя из Паспорта.'),
        'display_name': StringField(help_text=u'Отображаемое имя.'),
        'avatar_url': UrlField(help_text=u'Ссылка на аватарку.'),
        'is_default_avatar': BooleanField(help_text=u'Если true, то аватар является дефолтным.'),
        'login': StringField(help_text=u'Логин.'),
        'country': StringField(help_text=u'Страна пользователя из Паспорта.'),
        'is_yandex_staff': BooleanField(help_text=u'Признак того, что пользователь привязан к Стаффу.'),
        'broadcast_allowed': BooleanField(help_text=u'Признак того, что трансляции включены.', required=False),
        'broadcast_feature_enabled': BooleanField(
            help_text=u'Признак того, что у пользователя включена фича трансляций.', required=False)
    }


class UserFeatureTogglesSerializer(BaseSerializer):
    fields = {
        'promote_mail360': SerializerField(
            FeatureToggleSerializer, source='promote_mail360', required=False,
            help_text=u'Промоутинг Почты 360 включен (true) или нет (false)'
        )
    }
    visible_fields = fields.keys()


class LeaveRoomSerializer(BaseSerializer):
    pass


class TelemostForbiddenErrorWithLinkSerializer(ErrorWithContextSerializer):
    visible_fields = ErrorWithContextSerializer.visible_fields + ['yandex_team_join_link']

    fields = {
        'yandex_team_join_link': UrlField(help_text=u'Ссылка на конференцию для переподключения.'),
    }


class TelemostInviteLinkNotComeSerializer(ErrorWithContextSerializer):
    visible_fields = ErrorWithContextSerializer.visible_fields + ['start_event_time']

    fields = {
        'start_event_time': IntegerField(help_text=u'Timestamp времени начала встречи.'),
    }


# ===============================================================================
# Broadcasts
# ===============================================================================

class CreateBroadcastBodySerializer(BaseSerializer):
    visible_fields = ['caption', 'description']
    fields = {
        'caption': StringField(help_text=u'Название трансляции.', required=False),
        'description': StringField(help_text=u'Описание трансляции.', required=False),
    }


class BroadcastDataSerializer(BaseSerializer):
    visible_fields = ['broadcast_uri', 'broadcast_chat_path']
    fields = {
        'broadcast_uri': UrlField(help_text=u'Ссылка на подключение к трансляции для просмотра.'),
        'broadcast_chat_path': StringField(help_text=u'Путь до чата без указания хоста.'),
    }


# ===============================================================================
# Streams
# ===============================================================================

class StreamDataSerializer(BaseSerializer):
    visible_fields = ['owner_uid', 'started_at', 'stopped_at', 'ugc_live_slug']
    fields = {
        'owner_uid': StringField(help_text=u'Пользователь, который запустил текущий стрим.'),
        'started_at': IntegerField(help_text=u'Timestamp времени запуска стрима.'),
        'stopped_at': IntegerField(help_text=u'Timestamp времени остановки стрима.', required=False),
        'stream_uri': StringField(help_text=u'Ссылка для плеера просмотрщика трансляции.', required=False),
    }


# ===============================================================================
# Viewers
# ===============================================================================

class ViewerDataSerializer(BaseSerializer):
    visible_fields = ['stream_uri', 'start_event_time', 'caption', 'description', 'broadcast_chat_path', 'status',
                      'display_name', 'started_at']
    fields = {
        'stream_uri': UrlField(help_text=u'Ссылка для плеера просмотрщика трансляции.'),
        'start_event_time': IntegerField(help_text=u'Timestamp времени начала трансляции.', required=False),
        'caption': StringField(help_text=u'Наименование трансляции.', required=False),
        'description': StringField(help_text=u'Описание трансляции.', required=False),
        'broadcast_chat_path': StringField(help_text=u'Путь до чата без указания хоста.', required=False),
        'status': StringField(help_text=u'Статус трансляции.', required=False),
        'display_name': StringField(help_text=u'Отображаемое имя пользователя, который создал трансляцию.', required=False),
        'started_at': IntegerField(help_text=u'Timestamp времени запуска стрима.', required=False),
    }
