# -*- coding: utf-8 -*-
"""
Platform validators.

A validator is merely a callable object or function that takes a value and simply returns nothing if the value is valid
or raises a PlatformValidationError if not.
"""
import re 
from mpfs.platform.exceptions import FieldValidationError

EMPTY_VALUES = (None, '', [], (), {})


class RegExpValidator(object):
    def __init__(self, pattern, flags=0):
        self.compiled_pattern = re.compile(pattern, flags)

    def __call__(self, value):
        if not self.compiled_pattern.search(value):
            msg = u"недопустимое значение"
            desc = u"invalid value"
            raise FieldValidationError(name='preview_size', message=msg, description=desc)
