# -*- coding: utf-8 -*-
import datetime


def get_datetime_iso(days_shift=0):
    date = datetime.datetime.now()
    date += datetime.timedelta(days=days_shift)
    return date.strftime('%Y-%m-%dT%H:%M:%SZ')


class IntervalsData:
    # есть:
    #   * активный интервал
    #   * остановленный интервал
    DEFAULT = {"result": {"intervals": [{"orderInfo": {"startSubscriptionMailMuted": False,
                                                       "switched": False,
                                                       "id": 50607744,
                                                       "orderType": "native-auto-subscription",
                                                       "region": 225,
                                                       "productInfo": {"brand": "disk_plus",
                                                                       "bundle": "disk-basic",
                                                                       "features": ["basic-plus",
                                                                                    "disk-basic",
                                                                                    "basic-music"],
                                                                       "id": "ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750",
                                                                       "type": "subscription",
                                                                       "price": {"amount": 750,
                                                                                 "currency": "RUB"},
                                                                       "vendor": "yandex",
                                                                       "commonPeriod": "P1M",
                                                                       "debug": False,
                                                                       "family": False,
                                                                       "promoTrial": False},
                                                       "stopped": "2020-07-12T07:31:09Z",
                                                       "lastGrace": {"end": "2020-07-12T07:31:00Z",
                                                                     "start": "2020-07-05T07:31:00Z"},
                                                       "paymentSchema": "simple",
                                                       "expires": "2020-07-12T07:31:09Z"},
                                         "end": "2020-07-12T07:31:09Z",
                                         "start": "2020-02-05T07:31:00Z"},
                                        {"orderInfo": {"startSubscriptionMailMuted": False,
                                                       "id": 87606913,
                                                       "orderType": "native-auto-subscription",
                                                       "region": 225,
                                                       "productInfo": {"brand": "disk_plus",
                                                                       "bundle": "disk-new-plus",
                                                                       "features": ["basic-plus",
                                                                                    "disk-basic",
                                                                                    "basic-music",
                                                                                    "basic-kinopoisk"],
                                                                       "id": "ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750",
                                                                       "type": "subscription",
                                                                       "price": {"amount": 750,
                                                                                 "currency": "RUB"},
                                                                       "vendor": "yandex",
                                                                       "commonPeriod": "P1M",
                                                                       "debug": False,
                                                                       "family": False,
                                                                       "promoTrial": False},
                                                       "paymentSchema": "simple",
                                                       "expires": get_datetime_iso(days_shift=2),
                                                       "nextPayment": get_datetime_iso(days_shift=2),
                                                       "switched": False},
                                         "end": get_datetime_iso(days_shift=2),
                                         "start": "2020-09-04T13:39:36Z"}]},
               "invocationInfo": {"app-version": "2020-10-02.stable-105.7423332 (7423332; 2020-10-02T18:31:36)",
                                  "app-name": "mediabilling-api",
                                  "action": "GET_BillingIntervalsActionContainer.getIntervals/intervals",
                                  "exec-duration-millis": 30,
                                  "hostname": "mediabilling-prod-api-myt-9.myt.yp-c.yandex.net",
                                  "req-id": "1601886321317987-16780828366681812003"}}


class NativeProducts:
    # default - обычные продукты для сервиса Disk
    DEFAULT = {"result": {"nativeProducts": [{"trialAvailable": False,
                                              "available": True,
                                              "fbName": "disk-new-plus",
                                              "fbImage": "",
                                              "familySub": False,
                                              "title": "Yandex",
                                              "feature": "disk-new-plus",
                                              "plus": True,
                                              "price": {"currency": "RUB",
                                                        "amount": 750},
                                              "trialDuration": 0,
                                              "duration": 30,
                                              "commonPeriodDuration": "P1M",
                                              "type": "subscription",
                                              "productId": "ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750",
                                              "features": ["basic-music",
                                                           "disk-basic",
                                              "basic-kinopoisk",
                                              "basic-plus"],
                                              "debug": False,
                                              "customPayload": "{}",
                                              "description": "Плюс",
                                              "buttonText": "750 ₽ в месяц",
                                              "buttonAdditionalText": "ежемесячная оплата",
                                              "cheapest": True,
                                              "paymentMethodTypes": ["card"]},
                                             {"trialAvailable": False,
                                              "available": True,
                                              "fbName": "disk-new-plus",
                                              "fbImage": "",
                                              "familySub": False,
                                              "feature": "disk-new-plus",
                                              "plus": True,
                                              "price": {"currency": "RUB",
                                                        "amount": 6500},
                                              "trialDuration": 0,
                                              "duration": 360,
                                              "commonPeriodDuration": "P1Y",
                                              "type": "subscription",
                                              "productId": "ru.yandex.web.disk.native.1year.autorenewable.notrial.disk_basic.6500",
                                              "features": ["basic-music",
                                                           "disk-basic",
                                                           "basic-kinopoisk",
                                                           "basic-plus"],
                                              "debug": False,
                                              "customPayload": "{}",
                                              "description": "Плюс",
                                              "buttonText": "6500 ₽ в год",
                                              "buttonAdditionalText": "ежегодная оплата",
                                              "paymentMethodTypes": ["card"],
                                              "title": "Yandex"}],
                          "campaign": {"description": "",
                                       "title": "Оформите подписку и пользуйтесь всеми возможностями сервиса"},
                          "target": "disk"},
               "invocationInfo": {
               "exec-duration-millis": "78",
               "req-id": "1622028269836128-1887823011762215146",
               "app-version": "2021-05-26.stable-527.8198539 (8198539; 2021-05-26T07:19:05)",
               "app-name": "music-web",
               "action": "GET_InternalAccountActionContainer.getNativeProducts/native-products",
               "hostname": "music-test-back-sas-1.sas.yp-c.yandex.net"}}
