# -*- coding: utf-8 -*-
from collections import defaultdict
from contextlib import contextmanager
from copy import copy, deepcopy


def reset_users_info():
    global USERS_INFO
    USERS_INFO = deepcopy(DEFAULT_USERS_INFO)


def get_info_with_defaults(info):
    result = copy(DEFAULT_INFO)
    result.update(info)
    return result


def get_info_by_login(login):
    if ('@yandex.ru' in login or
        '@ya.ru' in login):
        login = login.split('@')[0]
    for user_info in USERS_INFO.values():
        if (user_info['login'] == login or
            user_info['email'] == login):
            return get_info_with_defaults(user_info)
    else:
        return defaultdict(bool)


def get_info_by_uid(uid):
    user_info = USERS_INFO.get(uid, DEFAULT_INFO)
    return get_info_with_defaults(user_info)


def update_info_by_uid(uid, has_staff=None, is_2fa_enabled=None, yateam_uid=None, yateam_login=None, is_enabled=None,
                       login=None, language=None, has_telemost=None, has_mail360=None, sso_user=None, domain_id=None):
    if uid not in USERS_INFO:
        raise ValueError

    if has_staff is not None:
        USERS_INFO[uid]['has_staff'] = has_staff
    if is_2fa_enabled is not None:
        USERS_INFO[uid]['is_2fa_enabled'] = is_2fa_enabled
    if yateam_uid is not None:
        USERS_INFO[uid]['yateam_uid'] = yateam_uid
    if yateam_login is not None:
        USERS_INFO[uid]['yateam_login'] = yateam_login
    if is_enabled is not None:
        USERS_INFO[uid]['is_enabled'] = is_enabled
    if login is not None:
        USERS_INFO[uid]['login'] = login
    if language is not None:
        USERS_INFO[uid]['language'] = language
    if has_telemost is not None:
        USERS_INFO[uid]['has_telemost'] = has_telemost
    if has_mail360 is not None:
        USERS_INFO[uid]['has_mail360'] = has_mail360
    if sso_user is not None:
        USERS_INFO[uid]['sso_user'] = sso_user
    if domain_id is not None:
        USERS_INFO[uid]['domain_id'] = domain_id


@contextmanager
def empty_userinfo(uid):
    import test.helpers.stubs.resources.users_info
    before = test.helpers.stubs.resources.users_info.get_info_by_uid

    def my_get_info_by_uid(self, *args, **kwargs):
        result = copy(EMPTY_USER_INFO_TEMPLATE)
        result['id'] = uid
        return result

    try:
        test.helpers.stubs.resources.users_info.get_info_by_uid = my_get_info_by_uid
        yield my_get_info_by_uid
    finally:
        test.helpers.stubs.resources.users_info.get_info_by_uid = before


DEFAULT_INFO = {
    'username': None,
    'has_desktop_disk': False,
    'has_disk': False,
    'uid': None,
    'firstname': None,
    'lastname': None,
    'locations': {},
    'sex': None,
    'pdd_domain': None,
    'personalization': False,
    'birth_date': None,
    'login': '',
    'city': None,
    'has_staff': False,
    'has_music': False,
    'has_plus': False,
    'has_telemost': False,
    'has_mail360': False,
    'has_password': True,
    'display_name': '',
    'public_name': '',
    'language': None,
    'country': None,
    'id': u'12345',
    'reg_date': None,
    'is_2fa_enabled': False,
    'karma': 0,
    'has_mobile_disk': False,
    'is_app_password_enabled': False,
    'decoded_email': '',
    'pdd': False,
    'undeletable': False,
    'email': '',
    'avatar': '',
    'is_enabled': False,
}

DEFAULT_USERS_INFO = {
    '128280859': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'128280859',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test',
        'city': None,
        'has_staff': False,
        'has_portal_login': True,
        'has_music': False,
        'display_name': u'mpfs-test',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'128280859',
        'reg_date': 1310547467,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/21377/128280859-15854844/islands-200',
        'email': u'mpfs-test@yandex.ru',
        'is_enabled': True,
        'address-list': [
            {
              "rpop": False,
              "silent": False,
              "default": True,
              "unsafe": False,
              "address": "mpfs-test@yandex.ru",
              "validated": True,
              "native": True
            }
        ],
    },
    '376338392': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'376338392',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test-4',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test-4',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'376338392',
        'reg_date': 1460027695,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test-4@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs-test-4@yandex.ru',
        'is_enabled': True,
    },
    '415264318': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'415264318',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs.tester',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs.tester',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'415264318',
        'reg_date': 1472732087,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs.tester@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs.tester@yandex.ru',
        'is_enabled': True,
    },
    '415264988': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'415264988',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs.tester.1',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs.tester.1',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'415264988',
        'reg_date': 1472732220,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs.tester.1@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs.tester.1@yandex.ru',
        'is_enabled': True,
    },
    '415265582': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'415265582',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs.tester.2',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs.tester.2',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'415265582',
        'reg_date': 1472732328,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs.tester.2@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs.tester.2@yandex.ru',
        'is_enabled': True,
    },
    '166843649': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'166843649',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test-3',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test-3',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'166843649',
        'reg_date': 1343386311,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test-3@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs-test-3@yandex.ru',
        'is_enabled': True,
    },
    '415266357': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'415266357',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs.tester.4',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs.tester.4',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'415266357',
        'reg_date': 1472732481,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs.tester.4@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs.tester.4@yandex.ru',
        'is_enabled': True,
    },
    '415265999': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'415265999',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs.tester.3',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs.tester.3',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'415265999',
        'reg_date': 1472732411,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs.tester.3@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs.tester.3@yandex.ru',
        'is_enabled': True,
    },
    '415266694': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'415266694',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs.tester.5',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs.tester.5',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'415266694',
        'reg_date': 1472732546,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs.tester.5@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs.tester.5@yandex.ru',
        'is_enabled': True,
    },
    '166843460': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'166843460',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test-1',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test-1',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'166843460',
        'reg_date': 1343386181,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test-1@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs-test-1@yandex.ru',
        'is_enabled': True,
    },
    '132494351': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'132494351',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'testturk02',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'testturk02',
        'public_name': u'Vasily P.',
        'language': u'tr',
        'country': u'tr',
        'id': u'132494351',
        'reg_date': 1316420514,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'testturk02@yandex.com',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'testturk02@yandex.com',
        'is_enabled': True,
    },
    '1130000011801531': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': True,
        'has_disk': True,
        'uid': u'1130000011801531',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': u'mellior.ru',
        'personalization': False,
        'birth_date': None,
        'login': u'robbitter-3368777510@mellior.ru',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'robbitter-3368777510@mellior.ru',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'1130000011801531',
        'reg_date': 1391074930,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': True,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'robbitter-3368777510@mellior.ru',
        'pdd': True,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/30431/1130000011801531-28309113/islands-200',
        'email': u'robbitter-3368777510@mellior.ru',
        'is_enabled': True,
    },
    '89031628': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': True,
        'has_disk': True,
        'uid': u'89031628',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mikhail.v.belov',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mikhail.v.belov',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'89031628',
        'reg_date': 1271364726,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': True,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mikhail.v.belov@yandex.ru',
        'pdd': False,
        'undeletable': True,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/21493/89031628-16789523/islands-200',
        'email': u'mikhail.v.belov@yandex.ru',
        'is_enabled': True,
    },
    '397139837': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'397139837',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'ya.t1p',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'ya.t1p',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'397139837',
        'reg_date': 1467201004,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'ya.t1p@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'ya.t1p@yandex.ru',
        'is_enabled': True,
    },
    '1130000001924755': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'1130000001924755',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': u'leksunin.com',
        'personalization': False,
        'birth_date': None,
        'login': u'oleg@leksunin.com',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'oleg@leksunin.com',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'1130000001924755',
        'reg_date': 1316259581,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': True,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'oleg@leksunin.com',
        'pdd': True,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'oleg@leksunin.com',
        'is_enabled': True,
    },
    '1130000000156353': {
        'username': None,
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'1130000000156353',
        'firstname': u'',
        'lastname': u'',
        'locations': {},
        'sex': None,
        'pdd_domain': u'pochta.tvoe.tv',
        'personalization': False,
        'birth_date': None,
        'login': u'32max@pochta.tvoe.tv',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'32max@pochta.tvoe.tv',
        'public_name': u'32max@pochta.tvoe.tv',
        'language': u'ru',
        'country': u'ru',
        'id': u'1130000000156353',
        'reg_date': 1269873974,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'32max@pochta.tvoe.tv',
        'pdd': True,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'32max@pochta.tvoe.tv',
        'is_enabled': True,
    },
    '1130000000156481': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'1130000000156481',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': u'pochta.tvoe.tv',
        'personalization': False,
        'birth_date': None,
        'login': u'sokolik@pochta.tvoe.tv',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'sokolik@pochta.tvoe.tv',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'1130000000156481',
        'reg_date': 1269874062,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'sokolik@pochta.tvoe.tv',
        'pdd': True,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'sokolik@pochta.tvoe.tv',
        'is_enabled': True,
    },
    '1130000000156355': {
        'username': None,
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'1130000000156355',
        'firstname': u'',
        'lastname': u'',
        'locations': {},
        'sex': None,
        'pdd_domain': u'pochta.tvoe.tv',
        'personalization': False,
        'birth_date': None,
        'login': u'amba@pochta.tvoe.tv',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'amba@pochta.tvoe.tv',
        'public_name': u'amba@pochta.tvoe.tv',
        'language': u'ru',
        'country': u'ru',
        'id': u'1130000000156355',
        'reg_date': 1269873975,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'amba@pochta.tvoe.tv',
        'pdd': True,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'amba@pochta.tvoe.tv',
        'is_enabled': True,
    },
    '410033615': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'410033615',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test-6',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test-6',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'410033615',
        'reg_date': 1470914015,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test-6@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs-test-6@yandex.ru',
        'is_enabled': True,
    },
    '410034243': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': False,
        'uid': u'410034243',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test-7',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test-7',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'410034243',
        'reg_date': 1470914190,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test-7@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'mpfs-test-7@yandex.ru',
        'is_enabled': True,
    },
    '3000257047': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'3000257047',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test-oauth',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test-oauth',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'3000257047',
        'reg_date': 1310547467,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test-oauth@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/21377/128280859-15854844/islands-200',
        'email': u'mpfs-test-oauth@yandex.ru',
        'is_enabled': True,
    },
    'deleted_account': {
        'avatar': '',
        'birth_date': None,
        'city': None,
        'country': None,
        'decoded_email': '',
        'display_name': '',
        'public_name': '',
        'email': '',
        'firstname': None,
        'has_desktop_disk': False,
        'has_disk': False,
        'has_mobile_disk': False,
        'has_music': False,
        'has_staff': False,
        'id': u'9999999999999999',
        'is_2fa_enabled': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'karma': 0,
        'language': None,
        'lastname': None,
        'locations': {},
        'login': '',
        'pdd': False,
        'pdd_accepted_agreement': None,
        'pdd_domain': None,
        'personalization': False,
        'reg_date': None,
        'sex': None,
        'uid': None,
        'undeletable': False,
        'username': None,
        'is_enabled': False,
    },
    '520161280': {  # mailish пользователь
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'birth_date': None,
        'city': None,
        'country': u'ru',
        'decoded_email': '',
        'display_name': u'yatestvs@gmail.com',
        'public_name': u'yatestvs@gmail.com',
        'email': '',
        'firstname': u'',
        'has_desktop_disk': False,
        'has_disk': False,
        'has_mobile_disk': False,
        'has_music': False,
        'has_staff': False,
        'id': u'520161280',
        'is_2fa_enabled': False,
        'is_app_password_enabled': False,
        'is_mailish': True,
        'karma': 0,
        'language': u'ru',
        'lastname': u'',
        'locations': {},
        'login': u'yatestvs@gmail.com',
        'pdd': False,
        'pdd_accepted_agreement': None,
        'pdd_domain': None,
        'personalization': False,
        'reg_date': 1499251061,
        'sex': None,
        'uid': u'520161280',
        'undeletable': False,
        'username': None,
        'is_enabled': True,
    },
    '4009138240': {
        'username': u'Share Master',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'4009138240',
        'firstname': u'Share',
        'lastname': u'Master',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'yndx-share-master',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'Share Master',
        'public_name': u'Share Master',
        'language': u'ru',
        'country': u'ru',
        'id': u'4009138240',
        'reg_date': 1310547467,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': True,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'yndx-share-master@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'yndx-share-master@yandex.ru',
        'is_enabled': True,
    },
    '4009138248': {
        'username': u'Share Slave',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'4009138248',
        'firstname': u'Share',
        'lastname': u'Slave',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'yndx-share-slave',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'Share Slave',
        'public_name': u'Share Slave',
        'language': u'ru',
        'country': u'ru',
        'id': u'4009138248',
        'reg_date': 1310547467,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': True,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'yndx-share-slave@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'yndx-share-slave@yandex.ru',
        'is_enabled': True,
    },
    '112358': {
        'username': u'Fake Plus',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'112358',
        'firstname': u'Fake',
        'lastname': u'Plus',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'ya.plus',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'has_plus': True,
        'display_name': u'Fake Plus',
        'public_name': u'Fake Plus',
        'language': u'ru',
        'country': u'ru',
        'id': u'112358',
        'reg_date': 1310547467,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': True,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'ya.plus@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/0/0-0/islands-200',
        'email': u'ya.plus@yandex.ru',
        'is_enabled': True,
    },
    '198311081': {
        'username': u'Vasily Pupkin',
        'has_desktop_disk': False,
        'has_disk': True,
        'uid': u'198311081',
        'firstname': u'Vasily',
        'lastname': u'Pupkin',
        'locations': {},
        'sex': None,
        'pdd_domain': None,
        'personalization': False,
        'birth_date': None,
        'login': u'mpfs-test',
        'city': None,
        'has_staff': False,
        'has_music': False,
        'display_name': u'mpfs-test',
        'public_name': u'Vasily P.',
        'language': u'ru',
        'country': u'ru',
        'id': u'198311081',
        'reg_date': 1310547467,
        'is_2fa_enabled': False,
        'karma': 0,
        'has_mobile_disk': False,
        'is_app_password_enabled': False,
        'is_mailish': False,
        'decoded_email': u'mpfs-test@yandex.ru',
        'pdd': False,
        'undeletable': False,
        'avatar': u'https://avatars.mdst.yandex.net/get-yapic/21377/128280859-15854844/islands-200',
        'email': u'mpfs-test@yandex.ru',
        'is_enabled': True,
    },
}

EMPTY_USER_INFO_TEMPLATE = {
    'username': None,
    'has_desktop_disk': False,
    'has_disk': False,
    'uid': None,
    'firstname': None,
    'lastname': None,
    'locations': {},
    'sex': None,
    'pdd_domain': None,
    'personalization': False,
    'birth_date': None,
    'login': '',
    'city': None,
    'has_staff': False,
    'has_music': False,
    'has_plus': False,
    'display_name': '',
    'public_name': '',
    'language': None,
    'country': None,
    'id': None,
    'reg_date': None,
    'is_2fa_enabled': False,
    'karma': 0,
    'has_mobile_disk': False,
    'is_app_password_enabled': False,
    'decoded_email': '',
    'pdd': False,
    'undeletable': False,
    'email': '',
    'avatar': '',
}

USERS_INFO = None


RAW_PASSPORT_USER_INFO = {
  "users": [
    {
      "address-list": [
        {
          "born-date": "2022-06-06 15:19:18",
          "native": True,
          "unsafe": False,
          "silent": False,
          "rpop": False,
          "default": False,
          "validated": True,
          "address": "test-sarah139@ya.ru"
        },
        {
          "born-date": "2022-06-06 15:19:18",
          "native": True,
          "unsafe": False,
          "silent": False,
          "rpop": False,
          "default": True,
          "validated": True,
          "address": "test-sarah139@yandex.ru"
        }
      ],
      "attributes": {
        "78": "1",
        "34": "ru",
        "31": "ru",
        "197": "1",
        "1017": "110091,110093",
        "1009": "1",
        "1005": "1",
        "1": "1654517958",
        "1031": "7401243"
      },
      "dbfields": {
        "userinfo.lastname.uid": "test-sarah139",
        "userinfo.firstname.uid": "test-sarah139"
      },
      "display_name": {
        "avatar": {
          "empty": True,
          "default": "0/0-0"
        },
        "third_party_can_use": False,
        "has_public_profile": False,
        "public_name": "test-sarah139 test-sarah139",
        "name": "test-sarah139"
      },
      "regname": "test-sarah139",
      "id": "4097156942",
      "uid": {
        "hosted": False,
        "lite": False,
        "value": "4097156942"
      },
      "login": "test-sarah139",
      "have_password": True,
      "have_hint": False,
      "aliases": {
        "1": "test-sarah139"
      },
      "karma": {
        "value": 0
      },
      "karma_status": {
        "value": 0
      }
    }
  ]
}
