# -*- coding: utf-8 -*-
import click


def parse_stid_stdin():
    for line in click.get_text_stream('stdin'):
        if not line:
            continue
        try:
            size, stid = line.split()
            if size.startswith('size='):
                size = size[5:]
            size = int(size)
            if stid.startswith('stid='):
                stid = stid[5:]
        except Exception:
            continue
        else:
            yield stid, size


@click.command('add_stids_to_deleted', help=u"Докинуть стиды на в лог deleted-stids")
@click.option('-s', '--stid-source', default='gc_clean', help=u'Значение поля stid_source')
@click.option('--chunk-size', default=500, help=u'Размер чанка для записи в лог')
def add_stids_to_deleted(stid_source, chunk_size):
    import mpfs.engine.process
    mpfs.engine.process.setup_admin_script()
    from mpfs.common.util import chunks2
    from mpfs.core.filesystem.cleaner.models import DeletedStid
    for stids_chunk in chunks2(parse_stid_stdin(), chunk_size=chunk_size):
        deleted_stids_chunk = [
            DeletedStid(stid=stid, size=size, stid_source=stid_source)
            for stid, size in stids_chunk
        ]
        DeletedStid.controller.bulk_create(deleted_stids_chunk)

if __name__ == '__main__':
    add_stids_to_deleted()
