#!/bin/bash
set -e

pr_id=$1
token=$(cat ~/.arcanum_token)

function error_exit {
    echo
    echo -e "\033[1m\033[31m$@\033[0m" 1>&2
    exit 1
}


uncommitted_changes=$(ya svn st -q)
if [ -n "$uncommitted_changes" ]; then
    error_exit "THERE ARE UNCOMMITTED CHANGES. PATCH FROM PR DOES NOT APPLY."
fi


response_code=$(curl -k -H "Authorization: OAuth $token" --write-out %{http_code} --silent --output diff.patch https://a.yandex-team.ru/api/v1/review-requests/$pr_id/patch)

if [ "$response_code" -ne 200 ]; then
    error_exit "failed to fetch pr; status: "$response_code
fi

sed -i.bak 's/trunk\/arcadia\/disk\/mpfs\///g' diff.patch
# for PRs from arc
sed -i.bak 's/+++ disk\/mpfs\//+++ /g' diff.patch
sed -i.bak 's/--- disk\/mpfs\//--- /g' diff.patch

ya svn patch diff.patch

rm diff.patch diff.patch.bak || true
