#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
MPFS Tools
Local Build & Install
"""
import os
import ConfigParser
import sys, traceback
import getopt
import commands
import platform
from optparse import OptionParser, Option

from time import sleep, ctime, time

from build_common import copy_deb_related_files, remove_deb_related_files

CONFIG_FILE = 'tools/builder.conf'

usage = "usage: %prog -h"

option_list = (
    Option(
       '-p', '--packages',
       action='store',
       dest='packages',
       default='',
       help='packages: disk, api, browser, queue',
    ),
    Option(
        '-i', '--ignore',
        action='store_true',
        dest='ignore_test',
        default=False,
        help='Ignore tests` result'
    ),
    Option(
        '-s', '--skip',
        action='store_true',
        dest='skip',
        default=False,
        help='Do not run tests'
    ),
    Option(
       '--out',
       action='store_true',
       dest='print_out',
       default=False,
       help='Print out',
    ),
    Option(
        '-w', '--without-installation',
        action='store_true',
        dest='do_not_install',
        default=False,
        help='Do not install packages'
    ),

)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def do_test(print_out):
    test_out = commands.getoutput("./tools/test.sh")
    fail = 'ERROR' in test_out or 'FAIL' in test_out
    if fail or print_out:
        print test_out
    return fail


def main():
    config = ConfigParser.ConfigParser()
    config.read(CONFIG_FILE)
    packages = []
    
    test_fails = []
    if options.packages:
        packages = options.packages.split(',')
    else:
        for k, v in dict(config.items('packages')).iteritems():
            packages.append(k)

    if not options.skip:
        test_fails.append(do_test(options.print_out))

        if True in test_fails:
            print ('Test failed, please fix errors')
            if options.ignore_test:
                print 'Building will be continued'
                sleep(3)
            else:
                sys.exit()

    results = []
    try:
        current_platform = platform.platform()
        if 'Ubuntu' in current_platform:
            import builder_deb as builder
        elif 'redhat' in current_platform:
            raise NotImplementedError()
        else:
            print '\nBuilder for current platform not found.\n'
            sys.exit(2)
        source_dir = os.path.expanduser('~') + '/mpfsbuild_dev'
        builder.set_source_dir(source_dir)
        builder.set_config(config)
        builder.clean()
        if os.path.exists(source_dir):
            os.system('rm -R %s/*' % source_dir)
        else:
            os.system('mkdir %s' % source_dir)
        os.system('cp -R ./* %s/' % source_dir)

        os.chdir(source_dir)

        os.system('cp apps/setup.py .')
        for package in packages:
            copy_deb_related_files(source_dir, package)

            results.append(builder.build(package, 'Local build'))
            if not options.do_not_install:
                install_result = builder.install(package)
                if install_result != 0:
                    print "Package installation error"
                    return

            remove_deb_related_files(source_dir, package)

    except Exception:
        print traceback.format_exc()
        sys.exit(2)
    else:
        return results
    finally:
        os.system('rm setup.py')


def usage():
    print """
    Usage:
    tools/bi.py [options]

    Options: --package, -p <name>       Build one package. By default - build all
             --help, -h                 Help
             --ignore, -i               Ignore test results
             --skip, -i                 Skip test
             --out, -i                  Print out
             --without-installation, -w Do not install packages
    
    """


if __name__ == "__main__":
    start = time()
    results = main()
    end = time()
    print "\n\tBuilt: %s\n\tNow: %s\n\tRequired: %.3f seconds\n" % (results, ctime(), end-start)
