#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import re

from collections import defaultdict


def fullsplit(path, result=None):
    """
    Split a pathname into components (the opposite of os.path.join) in a
    platform-neutral way.
    We took it from Django setup.py :)
    """
    if result is None:
        result = []
    head, tail = os.path.split(path)
    if head == '':
        return [tail] + result
    if head == path:
        return result
    return fullsplit(head, [tail] + result)


def get_packages_with_data(package_dir):
    old_dir = os.getcwd()
    parts = fullsplit(package_dir)
    head = parts[:-1]
    tail = parts[-1]
    os.chdir(os.path.join(*head))

    packages_with_data = {}
    for dirpath, dirnames, filenames in os.walk(tail):
        for i, dirname in enumerate(dirnames):
            if dirname.startswith('.'):
                del dirnames[i]
        package = '.'.join(fullsplit(dirpath))
        packages_with_data[package] = []
        for filename in filenames:
            if filename.endswith('.yaml'):
                packages_with_data[package].append(filename)

    os.chdir(old_dir)
    return packages_with_data


def build_data_files(dst_dir, src_dir, flat=False):
    dst_dir = os.path.normpath(dst_dir)
    src_dir = os.path.normpath(src_dir)
    result = defaultdict(list)
    for dirpath, _, filenames in os.walk(src_dir):
        cur_dst_dir = os.path.join(dst_dir, dirpath[len(src_dir) + 1:])
        for filename in filenames:
            res = os.path.join(dirpath, filename)
            result[cur_dst_dir].append(res)
        if flat:
            break
    return result.items()


def collect_data_files(path, extensions=tuple()):
    extensions = set(extensions)
    for root, dirs, files in os.walk(path):
        relative_path = root.replace(path, '', 1).lstrip('/')
        for file_ in files:
            _, ext = os.path.splitext(file_)
            if ext in extensions:
                yield os.path.join(relative_path, file_)


def get_package_name_from_deb_control(filepath):
    if not os.path.exists(filepath):
        return None

    deb_control_file = open(filepath, 'r')
    package = re.match(r'^Source:\s*(.*)\n', deb_control_file.read())
    if package is None:
        return None

    return package.group(1)


def copy_deb_related_files(source_dir, package, force=True):
    package_dir = '%s/apps/%s/deploy' % (source_dir, package)
    os.system('cp %s/README %s' % (package_dir, source_dir))

    if not force and os.path.exists('%s/debian' % source_dir):
        raise OSError('debian directory already exists')

    if os.path.exists('%s/debian' % source_dir):
        os.system('rm -R %s/debian' % source_dir)

    os.system('cp -R %s/debian %s' % (package_dir, source_dir))


def remove_deb_related_files(source_dir, package):
    os.system('rm %s/README' % source_dir)
    os.system('rm -r %s/debian' % source_dir)
