#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Скрипт для сборки и установки пакетов на девелоперскую виртуалку
"""

import traceback
import sys
import os

from time import time
from optparse import OptionParser, Option

import builder_base

usage = "usage: %prog -h"

option_list = (
    Option(
        '-p', '--package',
        action='store',
        dest='package',
        help='package name(api, disk, common, browser)'),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def main(package):
    package_type = package
    package_name = "python-mpfs-%s" % package
    version = '0.1'
    new_release = 1
    try:
        builder_base.build_pkg(package_type, package_name, version, new_release)
    except Exception:
        print traceback.format_exc()
        sys.exit(1)


if __name__ == "__main__":
    if options.package:
        package_list = [options.package, ]
    else:
        package_list = ['common', 'api', 'browser', 'disk']

    start = time()
    for pkg in package_list:
        main(pkg)
        os.system('sudo dpkg -i --force-all python-mpfs-%s_0.1-1_all.deb' % pkg)

    end = time()
    print "\n\tBuild finished in %.3f seconds.\n" % float(end-start)
