#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
MPFS Tools
Base Build Methods
"""

import sys
import subprocess
import os
import datetime
import time
import commands
import re
import urllib2
import traceback
import json


from dateutil.tz import tzlocal

__config__ = None
__source_dir__ = None
CONFIG_FILE = 'tools/builder.conf'

RE_LAST_COMMIT = re.compile('^building all: version \d+\.\d+ release \d+ platform (\w+)\n$')


def checkout(directory):
    os.system('rm -rf %s' % directory)
    os.system('git clone git@github.yandex-team.ru:MPFS/MPFS.git %s' % directory)


def set_config(config):
    global __config__
    __config__ = config


def get_config():
    global __config__
    return __config__


def set_source_dir(source_dir):
    global __source_dir__
    __source_dir__ = source_dir


def get_source_dir():
    global __source_dir__
    return __source_dir__


def config():
    c = get_config()
    version = c.get('global', 'version')
    release = int(c.get('global', 'release'))
    packages = dict(c.items('packages'))

    return (version, release, packages)


def checkout_branch(branch):
    subprocess.check_call(['git', 'checkout', branch])


def switch_branch(version):
    os.system('git checkout -b %s origin/%s' % (version, version))


def get_branch_name():
    return subprocess.check_output(["git", "rev-parse", "--abbrev-ref", "HEAD"]).replace('\n', '')


def get_user_name():
    os_user_name = os.getenv('USER')
    assert os_user_name
    return os_user_name


def get_user_email():
    login = get_user_name()
    email = '%s@yandex-team.ru' % login
    return email


def master_check():
    current = get_branch_name()
    if current == 'master':
        print "sorry, we don't build releases in master branch"
        sys.exit(2)


def switch_master():
    os.system('git checkout master')


def get_branches():
    branch_list = subprocess.check_output(['git', 'branch', '--all'])
    return branch_list.split()


def create_branch(version):
    return os.system('git checkout -b %s' % version)


def add_backup():
    os.system('git remote set-url origin --add git@github.yandex-team.ru:MPFS/MPFS.git')


def commit(platform):
    (version, release, packages) = config()

    os.system('git commit -a -m "building all: version %s release %s platform %s"' % (version, release, platform))
    return os.system('git push')


def commit_new_release(version):
    os.system('git commit -a -m "%s"' % (version))
    return os.system('git push')


def check_testing_version():
    (version, release, packages) = config()
    try:
        package_version = [x for x in json.loads(urllib2.urlopen('https://c.yandex-team.ru/api/packages_on_host/mpfs01d.dst.yandex.net?format=json').read()) if x['name'] == 'python-mpfs-disk'][0]['version']
        testing_version, testing_release = package_version.split('-')
        print "version: %s testing_version: %s release: %s testing_release: %s" % (version, testing_version, release, testing_release)
        if version == testing_version and int(release) > int(testing_release):
            return True
    except Exception:
        print traceback.format_exc()

    return False


def pull(delay=1):
    time.sleep(delay)
    os.system('git pull')


def update_mpfs_version(version, release=None):
    if release is None:
        release = 0
    release += 1
    cmd = "sed -ri \"s/__version__ = '[0-9\.]+'/__version__ = '%s.%s'/\" lib/mpfs/__init__.py" % (version, release)
    os.system(cmd)


def update_setup(package):
    (version, release, packages) = config()
    command = "sed -i \"s/version = '0.1'/version = '%s'/\" apps/setup.py" % version
    os.system(command)


def write_changelog(package, version, date={}):
    fullname = get_user_name()
    email = get_user_email()
    date_deb = date.get('deb')
    if date_deb:
        full_date = date_deb
    else:
        full_date = date['deb'] = datetime.datetime.now(tzlocal()).strftime("%a, %d %b %Y %H:%M:%S %z")
    record = 'python-mpfs-%s (%s-1) unstable; urgency=low\n\n  * Common Release\n\n -- %s <%s>  %s\n\n' % \
        (package, version, fullname, email, full_date)
    file_path = 'apps/%s/deploy/debian/changelog' % package
    with open(file_path, 'r+') as f:
        content = f.read()
        f.seek(0, 0)
        f.write(record + content)
    return file_path


def write_mpfs_version(version):
    file_path = 'lib/mpfs/__init__.py'
    with open(file_path, 'w') as f:
        f.write("# -*- coding: utf-8 -*-\n__version__ = '%s.1'\n" % version)
    return file_path


def update_config(release, platform=None, config=None, increment=True):
    if config is None:
        config = get_config()
    with open(CONFIG_FILE, 'wb') as configfile:
        if increment:
            config.set('global', 'release', str(release+1))
        if platform:
            config.set('global', 'last_build', platform)
        config.write(configfile)
        set_config(config)

def need_release_increment(platform):
    """
        Проверка: был ли собран пакет под другую платформу.
        Если пакет до этого был собран на другой платформе,
        то на текущей платформе он собирается с существующей версией.
    """
    last_commit = commands.getoutput('git log -1 --pretty=%B')
    match = re.match(RE_LAST_COMMIT, last_commit)
    if match and match.group(1) != platform:
        return False
    else:
        return True

def build_pkg(package_type, package_name, version, new_release):
    os.system('dch --distribution=unstable -b -v %s-%s "Common Release"' % (version, new_release))
    os.system('debuild --no-tgz-check')
