#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
MPFS Tools
DEB Build Methods
"""

import ConfigParser

from builder_base import *

homedir = os.path.expanduser('~')
deb_sources = homedir + '/debuild'
deb_build = homedir + '/debuild'
manifest = 'MANIFEST'
PLATFORM = 'deb'

try:
    os.makedirs(deb_sources)
except Exception:
    pass

def build(package, comment):
    (version, release, packages) = config()

    if package not in packages:
        print "cannot find %s source" % package
        sys.exit(2)

    source_dir = os.path.realpath(os.curdir)

    deb = packages[package]

    package_full_name = "%s-%s-%s" % (deb, version, release)

    try:
        os.system('mkdir %s/%s' % (deb_build, package_full_name))
        os.system('cp -R ./* %s/%s/' % (deb_build, package_full_name))

        if os.path.exists('%s/%s/etc' % (deb_build, package_full_name)):
            os.system("rm %s/%s/etc/*-rpm" % (deb_build, package_full_name))
            for element in os.listdir("%s/%s/etc" % (deb_build, package_full_name)):
                if element[-4:] == '-deb':
                    os.system('mv %s/%s/etc/%s %s/%s/etc/%s' % (deb_build, package_full_name, element, deb_build,
                                                                package_full_name, element[:-4]))

        deb_control_file = deb_build + '/' + package_full_name + '/debian/control'
        deb_changelog_file = deb_build + '/' + package_full_name + '/debian/changelog'
        today = datetime.datetime.now(tzlocal())
        os.system("sed -i 's/^Maintainer: .*$/Maintainer: %s <%s>/' %s" % (os.environ['DEBFULLNAME'], os.environ['DEBEMAIL'], deb_control_file))
        if comment == 'Local build':
            os.system('echo "%(package)s (%(version)s-%(build)s) unstable; urgency=low\n\n'
                      '  * Common Release\n\n -- %(full_name)s <%(email)s>  %(date)s\n" > %(file)s' % {
                        'package': deb,
                        'version': version,
                        'build': release,
                        'full_name': os.environ['DEBFULLNAME'],
                        'email': os.environ['DEBEMAIL'],
                        'date': today.strftime("%a, %d %b %Y %H:%M:%S %z"),
                        'file': deb_changelog_file}
                      )
        elif os.path.getsize(deb_changelog_file):
            os.chdir(deb_build + "/" + package_full_name)
            os.system("debchange -v '%s-%s' --distribution unstable --force-distribution '%s'" % (version, release, comment))
            os.chdir(source_dir)
        else:
            os.system("sed -i 's/^ --.*$/ -- %s <%s>  %s/' %s" % (os.environ['DEBFULLNAME'], os.environ['DEBEMAIL'], today.strftime("%a, %d %b %Y %H:%M:%S %z"), deb_changelog_file))
            os.system("sed -i '1s/([^)]*)/(%s-%s)/g' %s" % (version, release, deb_changelog_file))

        os.system("cp %s/%s/debian/changelog %s/debian/changelog" % (deb_build, package_full_name, source_dir))

        os.system("python setup.py sdist --formats=gztar")
        os.system("cp dist/%s-%s.tar.gz %s/%s_%s.orig.tar.gz" % (deb, version, deb_build, deb, version))
        os.chdir(deb_build + "/" + package_full_name)
        os.system("debuild")
        os.chdir(source_dir)
        os.system('rm -r %s/%s' % (deb_build, package_full_name))
        os.system('rm -r %s/%s_%s.orig.tar.gz' % (deb_build, deb, version))
        os.system('rm -r dist')
    except Exception:
        print traceback.format_exc()
        sys.exit(2)
    else:
        return package_full_name

def install(package):
    (version, release, packages) = config()

    if package not in packages:
        print "cannot find %s source" % package
        sys.exit(2)

    deb = packages[package]
    print "package %s-%s-%s install.." % (deb, version, release)
    return os.system('sudo dpkg -i --force-confnew --force-overwrite %s/%s_%s-%s_all.deb' % (deb_build, deb, version, release))

def upload(package):
    os.chdir(deb_build)
    (version, release, packages) = config()
    if package not in packages:
        print "cannot find %s source" % package
        sys.exit(2)
    deb = packages[package]
    package_full_name = "%s_%s-%s" % (deb, version, release)
    os.system("dupload --to yandex-precise %s_amd64.changes --nomail" % package_full_name)
    print "package %s uploaded" % package_full_name

def clean():
    os.system('rm -r %s/*' % deb_build)

def rupdate():
    return

def commit_new_release(version, release, do_increment=True):
    os.chdir(get_source_dir())
    update_config(release, platform=PLATFORM, increment=do_increment)
    return commit(PLATFORM)
