#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
MPFS Tools
Release Builder
"""

import ConfigParser
import sys,traceback
import os

from time import sleep, ctime, time
from optparse import OptionParser, Option

import builder_deb
from builder_base import CONFIG_FILE


usage = "usage: %prog -h"

option_list = (
    Option(
        '-v', '--version',
        action='store',
        dest='version',
        type='string',
        default=None,
        help='package version ~branch'
    ),
    Option(
       '-p', '--packages',
       action='store',
       dest='packages',
       default='',
       help='packages: common, disk, api, browser',
    ),
    Option(
        '-c', '--comment',
        action='store',
        dest='comment',
        default='Common Release',
        help='Comment for release'
           ),
    Option(
        '--no-upload',
        action='store_true',
        dest='no_upload',
        default=False,
        help='Do not upload package'
           ),
    Option(
       '--params',
       action='store',
       dest='params',
       default='',
       help='additional build parameters',
    ),
)


parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def main(version, test, cparams, builder, packages, comment):
    current_dir = os.path.realpath(os.curdir)
    git_dir = os.path.expanduser('~') + '/mpfsbuild'
    builder.set_source_dir(git_dir)
    builder.master_check()
    builder.clean()
    builder.checkout(git_dir)
    os.chdir(git_dir)
    builder.add_backup()
    builder.switch_branch(version)

    config = ConfigParser.ConfigParser()
    config.optionxform = str
    config.read(CONFIG_FILE)

    builder.set_config(config)

    release  = int(config.get('global', 'release'))
    if packages:
        packages = packages.split(',')
        packages = filter(lambda (k, v): k in packages, config.items('packages'))
    else:
        packages = config.items('packages')

    results = []
    try:
        do_increment = builder.need_release_increment(builder.PLATFORM)
        if do_increment:
            builder.update_config(release, config=config)
            builder.update_mpfs_version(version, release=release)

        for package_type, _ in packages:
            os.chdir(git_dir + '/' + package_type)
            results.append(builder.build(package_type, comment))
            if not options.no_upload:
                builder.upload(package_type)
                builder.rupdate()

        if not options.no_upload:
            os.chdir(current_dir)
            builder.pull()
            builder.switch_master()
    except Exception:
        print traceback.format_exc()
        os.chdir(current_dir)
        config = ConfigParser.ConfigParser()
        config.optionxform = str
        config.read(CONFIG_FILE)
        if int(config.get('global', 'release')) == release + 1:
            with open(CONFIG_FILE, 'wb') as configfile:
                config.set('global', 'release', release-1)
                config.write(configfile)
        sys.exit(2)
    return results


if __name__ == "__main__":
    version = options.version
    if version:
        cparams = options.params.split(',')
        test = options.test
        start = time()
        results = main(version, test, cparams, builder_deb, options.packages, options.comment)
        end = time()
        print "\n\tBuilt: %s\n\tNow: %s\n\tRequired: %.3f seconds.\n" % (results, ctime(), end-start)
    else:
        parser.print_usage()
