# -*- coding: utf-8 -*-
import requests
import threading
from multiprocessing.pool import ThreadPool
import os
import shutil
from argparse import ArgumentParser
# Создать архив из папки <FOLDER> без сжатия и разбить его партиции размером 700МБ
# 7zr a -r -v700m -mx0 -- <NAME>.7z <FOLDER>


HOST = 'http://mpfs01f.dsp.yandex.net'
PRINT_LOCK = threading.Lock()


def thread_save_print(msg):
    with PRINT_LOCK:
        print msg


def download(data):
    save_path, url = data
    if os.path.exists(save_path):
        thread_save_print('Already exists %s' % save_path)
        return
    r = requests.get(url, stream=True)
    with open(save_path, 'wb') as f:
        thread_save_print('Downloading %s' % save_path)
        shutil.copyfileobj(r.raw, f)


def parallel_download(urls):
    pool = ThreadPool(processes=10)
    pool.imap_unordered(download, urls)
    pool.close()
    pool.join()


def download_subtree(uid, path):
    resp = requests.get('%s/support/list' % HOST, params={'uid': uid, 'path': path, 'meta': 'file_url'})
    listing = resp.json()
    folder = listing[0]
    sub_resources = listing[1:]
    cur_dir_parts = ['.', uid] + list(os.path.split(folder['path'].strip('/')))
    cur_dir_path = os.path.join(*cur_dir_parts)
    if not os.path.exists(cur_dir_path):
        os.makedirs(cur_dir_path)

    file_urls = []
    dir_paths = []
    for sub_resource in sub_resources:
        if sub_resource['type'] == 'dir':
            dir_paths.append(sub_resource['path'])
        else:
            url = sub_resource['meta']['file_url']
            file_parts = cur_dir_parts + [sub_resource['name']]
            save_path = os.path.join(*file_parts)
            file_urls.append((save_path, url))
    parallel_download(file_urls)
    for dir_path in dir_paths:
        download_subtree(uid, dir_path)


if __name__ == '__main__':
    parser = ArgumentParser(description="Disk downloader.")
    parser.add_argument('-u', dest='uid', required=True, type=str, help='Uid.')
    parser.add_argument('--host', dest='host', default=HOST, type=str, help='MPFS host name.')
    args = parser.parse_args()
    HOST = args.host
    for path in ('/disk', '/attach', '/trash'):
        download_subtree(args.uid, path)
