#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
Генератор кронового конфига для воркеров для нужд расчета статистики

https://st.yandex-team.ru/CHEMODAN-25391
Берет все папки(отчеты) из lib/mpfs/core/mrstat и генерит json конфиг в STDOUT.
    > python tools/generate_mpfs_stat_cron_config.py > apps/disk/conf/bazinga/mpfs_stat_tasks.json
По умолчанию для нового отчета делает только дневной отчет. Если нужен и недельный, то
захардкодить в scale_settings
"""

import os
import json
from collections import defaultdict


REPO_ROOT_DIR = os.popen('git rev-parse --show-toplevel').read().strip("\n")
MRSTAT_DIR = os.path.join(REPO_ROOT_DIR, "lib/mpfs/core/mrstat")
available_reports_names = next(os.walk(MRSTAT_DIR))[1]

# Установленные значения периодов расчета. По дефолту только daily
scale_settings = defaultdict(
    lambda: ({
        'cron_exp': '30 5 * * *',
        'period_rounding': 'd',
    },),
    {
        'mpfs_mulca_clean_storage_updater': (
            {'cron_exp': '0 2 * * *',
             'period_rounding': 'd',
            },
        ),
        'mpfs_mulca_clean_intersection': (
            {'cron_exp': '30 4 * * *',
             'period_rounding': 'd',
             'name_suffix': 'previous_day'},
            {'cron_exp': '0 */3 * * *',
             'period_rounding': 'd',
             'extra_args': "-s `/bin/date '+%Y-%m-%d'`",
             'name_suffix': 'current_day'},
        ),
        'mpfs_mulca_clean_progress': (
            {'cron_exp': '30 3 * * *',
             'period_rounding': 'd'},
            {'cron_exp': '50 3 * * *',
             'period_rounding': 'h'},
        ),
    }
)

result = []
for report in available_reports_names:
    for launch_data in scale_settings[report]:
        task_name = "stat_%s_%s" % (report, launch_data['period_rounding'])
        if 'name_suffix' in launch_data:
            task_name += "_" + launch_data['name_suffix']
        task_name = task_name.replace('_', '-').replace(' ', '-')
        task_template = {
            "taskName": task_name,
            "cronExpression": launch_data['cron_exp'],
            "command": "/usr/bin/python /usr/lib/python2.7/dist-packages/mpfs/core/mrstat/%s/job.py "\
            "--scale %s %s >> /tmp/mpfs_stat_%s_%s.log 2>&1" % (report,
                                                                launch_data['period_rounding'],
                                                                launch_data.get('extra_args', ''),
                                                                report,
                                                                launch_data['period_rounding']),
            "timeout": "60m"
        }
        result.append(task_template)
print json.dumps(result, indent=4)
