# -*- coding: utf-8 -*-

"""
Подготавливает разработческую виртуалку для работы административного интерфейса апи.
Создает симлинки из мест, на которые завязана корректная работа приложения на файлы внутри репозитория.
Таким образом можно править просто код в репке, синкать на тачку и проверять что всё оке.
"""

import os
import shutil
import subprocess
import optparse

# TODO: Перенести его отсюда

# пути, на которые завязана работа приложения
LIBRARY_PATH = '/usr/lib/python2.7/dist-packages/api_admin'
SETTINGS_PATH = '/etc/yandex/mpfs-api-admin/conf/app'
ENTRY_PATH = '/usr/bin/wsgi_admin.py'
INIT_D_PATH = '/etc/init.d/mpfs-api-admin-uwsgi'
INIT_PATH = '/etc/init/mpfs-api-admin-uwsgi.conf'


dn = os.path.dirname
REPO_PATH = dn(dn(os.path.abspath(__file__)))

SYMLINK_MAP = {
    LIBRARY_PATH: os.path.join(REPO_PATH, 'lib', 'api_admin'),
    SETTINGS_PATH: os.path.join(REPO_PATH, 'apps', 'api', 'conf', 'admin'),
    ENTRY_PATH: os.path.join(REPO_PATH, 'apps', 'api', 'wsgi_admin.py'),
    INIT_D_PATH: '/lib/init/upstart-job',
    INIT_PATH: os.path.join(REPO_PATH, 'apps', 'api', 'conf', 'uwsgi', 'mpfs-api-admin-uwsgi.conf')

}


def install_api_admin():
    for from_, to_ in SYMLINK_MAP.iteritems():
        parent_to_ = os.path.dirname(to_)
        parent_from_ = os.path.dirname(from_)
        if not os.path.exists(parent_to_):
            os.makedirs(parent_to_, 0o777)

        if not os.path.exists(parent_from_):
            os.makedirs(parent_from_, 0o777)

        if from_.startswith('/etc/init/'):
            shutil.copy(to_, from_)
            print 'Copied %s to %s.' % (to_, from_)
            continue

        try:
            os.symlink(to_, from_)
        except OSError as e:
            if e.errno == 17:
                print 'Symbolic link "%s" -> "%s" already exists.' % (from_, to_)
            else:
                print from_, to_
                print e.message
                raise e
        else:
            print 'Made symbolic link: "%s" -> "%s".' % (from_, to_)

    os.system('initctl reload-configuration')
    print 'Executed "initctl reload-configuration".'


def uninstall_api_admin():
    with open(os.devnull) as f:
        subprocess.call(['sudo', 'service', 'mpfs-api-admin-uwsgi', 'stop'], stdout=f, stderr=f)

    for from_, to_ in SYMLINK_MAP.iteritems():
        try:
            shutil.rmtree(from_)
        except OSError as e:
            if e.errno == 2:  # No such file or directory
                pass
            else:
                os.remove(from_)
        print 'Deleted symbolic link: "%s" -> "%s".' % (from_, to_)

    os.system('initctl reload-configuration')
    print 'Executed "initctl reload-configuration".'


if os.geteuid() != 0:
    exit('You need to have root privileges.')


option_list = (
    optparse.Option(
        '-u', '--uninstall',
        action='store_true',
        dest='uninstall', default=False,
        help='Remove all Cloud API Admin symbolic links.'
    ),
)

if __name__ == '__main__':
    parser = optparse.OptionParser(option_list=option_list, usage=__doc__)
    (options, args) = parser.parse_args()
    if options.uninstall:
        uninstall_api_admin()
    else:
        uninstall_api_admin()
        install_api_admin()
