#! /usr/bin/env python
# -*- coding: utf-8 -*-
u"""Заменяет все установленные в системе файлы MPFS на симлинки в рабочую копию """
import optparse
import shutil
import os
import sys

from imp import load_source

sys.path.insert(0, os.path.abspath(os.path.join('.', 'tools')))
from build_common import copy_deb_related_files, remove_deb_related_files

MPFS_LOG_DIR = '/var/log/mpfs'
MPFS_BIN_DIR = '/usr/bin'
MPFS_SRC_DIR = '/usr/lib/python2.7/dist-packages/mpfs'
REPO_ROOT_DIR = os.popen('git rev-parse --show-toplevel').read().strip("\n")
if not os.path.isdir(REPO_ROOT_DIR):
    REPO_ROOT_DIR = os.path.dirname(os.path.dirname(os.path.realpath(__file__)))
EXTRA_SYMLINKS = (
    ('/lib/init/upstart-job', '/etc/init.d/mpfs-intapi-uwsgi'),
    ('/lib/init/upstart-job', '/etc/init.d/mpfs-extapi-uwsgi'),
    ('/lib/init/upstart-job', '/etc/init.d/mpfs-core-uwsgi-disk'),
    ('/lib/init/upstart-job', '/etc/init.d/mpfs-core-uwsgi-browser'),
    ('/lib/init/upstart-job', '/etc/init.d/mpfs-queue2'),
    ('/lib/init/upstart-job', '/etc/init.d/mpfs-queue2-worker'),
)


if os.geteuid() != 0:
    exit("You need to have root privileges.")
if not REPO_ROOT_DIR:
    exit("You should start script from MPFS repo dir.")


def make_parent_folder(path, mode=0o777):
    parent_dir = os.path.dirname(path)
    if not os.path.lexists(parent_dir):
        os.makedirs(parent_dir, mode)


def cp(src, dst):
    make_parent_folder(dst)
    try:
        shutil.copy(src, dst)
    except Exception:
        print 'Failed to copy: "%s" -> "%s".' % (src, dst)
        raise
    else:
        print 'Copy: "%s" -> "%s".' % (src, dst)


def symlink(src, dst):
    make_parent_folder(dst)
    try:
        os.symlink(src, dst)
    except OSError:
        try:
            os.unlink(dst)
            os.symlink(src, dst)
        except Exception:
            print 'Failed to create symbolic link(force): "%s" -> "%s".' % (src, dst)
            raise
        else:
            print 'Make symbolic link(force): "%s" -> "%s".' % (src, dst)
    except Exception:
        print 'Failed to create symbolic link: "%s" -> "%s".' % (src, dst)
        raise
    else:
        print 'Make symbolic link: "%s" -> "%s".' % (src, dst)


def rm(path):
    if os.path.lexists(path):
        path_type = None
        if os.path.islink(path):
            path_type = 'Symlink'
        elif os.path.isdir(path):
            path_type = 'Dir'
        elif os.path.isfile(path):
            path_type = 'File'
        try:
            shutil.rmtree(path)
        except OSError:
            os.remove(path)
        print '%s deleted. "%s"' % (path_type, path)
    else:
        print 'No file/dir/symlink to delete at "%s"' % path


def load_package_data(pkg_dirs=('api', 'browser', 'disk', 'queue')):
    """
    Получает из setup.py файлы scripts и data_files и генерирует список пар откуда их взять и куда положить
    """
    result = []
    os.chdir(REPO_ROOT_DIR)
    for pkg_dir in pkg_dirs:
        copy_deb_related_files(REPO_ROOT_DIR, pkg_dir, False)
        if os.path.exists('setup.py'):
            raise OSError('debian directory already exists')
        shutil.copy('apps/setup.py', 'setup.py')

        current_dir = os.getcwd()
        module = load_source('setup', 'setup.py')
        for src in module.SCRIPTS:
            name = os.path.basename(src)
            result.append((os.path.join(current_dir, src), os.path.join(MPFS_BIN_DIR, name)))
        for dst_dir, src_files in module.DATA_FILES:
            for src_path in src_files:
                src_name = os.path.basename(src_path)
                result.append((os.path.join(current_dir, src_path), os.path.join(dst_dir, src_name)))

        os.unlink('setup.py')
        os.unlink('setup.pyc')
        remove_deb_related_files(REPO_ROOT_DIR, pkg_dir)
    return result


def uninstall():
    rm(MPFS_SRC_DIR)
    rm(MPFS_LOG_DIR)
    for _, dst in load_package_data():
        rm(dst)
    for _, dst in EXTRA_SYMLINKS:
        rm(dst)


def install():
    os.chdir(REPO_ROOT_DIR)
    if not os.path.isdir(MPFS_LOG_DIR):
        os.mkdir(MPFS_LOG_DIR)
        os.chmod(MPFS_LOG_DIR, 0o777)
        print 'Make log dir. "%s"' % MPFS_LOG_DIR

    symlink(os.path.join(REPO_ROOT_DIR, 'lib/mpfs'), MPFS_SRC_DIR)
    for src, dst in load_package_data():
        if os.path.dirname(dst) == '/etc/init':
            # по симлинкам upstart не работает
            cp(src, dst)
        else:
            symlink(src, dst)
    for src, dst in EXTRA_SYMLINKS:
        symlink(src, dst)


option_list = (
    optparse.Option('-u', '--uninstall',
                    action='store_true',
                    dest='uninstall', default=False,
                    help='Remove all MPFS symbolic links.'),
)

if __name__ == '__main__':
    parser = optparse.OptionParser(option_list=option_list, usage=__doc__)
    (options, args) = parser.parse_args()
    if options.uninstall:
        uninstall()
    else:
        uninstall()
        install()
