#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Утилита создания новой релизной ветки
"""

import ConfigParser
import re
import subprocess
import sys
from argparse import ArgumentParser

from build import BuildConfig, SVNInfo
import builder_base as builder


CONFIG_FILE = 'tools/builder.conf'
RELEASE_BRANCH_REGEX = re.compile(r'(?:^|/)release-(\d+)\.(\d+)$')


def get_last_release():
    """
    :return: (major_ver, minor_ver)
    """
    branches = builder.get_branches()
    release_versions = []
    for branch in branches:
        match = RELEASE_BRANCH_REGEX.search(branch)
        if match:
            release_versions.append((int(match.group(1)), int(match.group(2))))
    return max(release_versions)


def main(version):
    config = BuildConfig()
    packages = dict(config.get_packages_list()).keys()

    if version == 'auto':
        major_ver, minor_ver = SVNInfo.get_last_release()
        version = '%s.%s' % (major_ver, minor_ver + 1)

    if not re.search(r'^\d\.\d+$', version):
        raise ValueError('Bad version format.')

    branch_name = "release-%s" % version
    subprocess.check_call(['ya',
                           'svn',
                           'copy',
                           '-m "mpfs: new release %s"' % version,
                           'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/disk/mpfs',
                           'svn+ssh://arcadia.yandex.ru/arc/branches/disk/mpfs/releases/%s' % branch_name])
    subprocess.check_call(['ya',
                           'svn',
                           'switch',
                           'svn+ssh://arcadia.yandex.ru/arc/branches/disk/mpfs/releases/%s' % branch_name])

    changed_files = []

    for package in packages:
        changed_file = builder.write_changelog(package, version)
        changed_files.append(changed_file)

    config.update(version=version, release=0)
    changed_files.append(config.CONFIG_PATH)

    changed_path = builder.write_mpfs_version(version)
    changed_files.append(changed_path)

    print 'Gonna commit into release branch:'
    subprocess.check_call(['ya', 'svn', 'diff'] + changed_files)

    subprocess.check_call('ya svn commit --with-revprop arcanum:review-skip=yes --with-revprop arcanum:check-skip=yes -m "mpfs: Update changelog/setup/mpfs version %s" %s' % (version, ' '.join(changed_files)),
                           shell=True)


if __name__ == "__main__":
    parser = ArgumentParser(description=__doc__)
    parser.add_argument('release', nargs=1, help='Номер релиза. `auto` - получить следующую версию из репы или `x.x`')
    namespace = parser.parse_args()
    main(namespace.release[0])
