#!/usr/bin/python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
from datetime import date, timedelta


if __name__ == '__main__':
    with open('/etc/yandex/disk-stat-token', 'r') as f:
        yttoken = f.read().strip()

    yt.config['token'] = yttoken
    yt.config['proxy']['url'] = settings.mrstat['yt_proxy']

    yesterday_date = date.today() - timedelta(days=1)
    date_str = yesterday_date.strftime('%Y-%m-%d')
    try:
        processed_stids_count = yt.row_count('//statbox/disk-mulca-clean-log/' + date_str)
    except yt.errors.YtHttpResponseError:
         processed_stids_count = 0

    print('processed_stids_count_Total %s' % processed_stids_count)
